<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function ea_enqueue_assets() {
    $theme_version = wp_get_theme()->get('Version');

    // Bootstrap
    wp_enqueue_style('bootstrap-css', get_template_directory_uri() . '/assets/bootstrap/css/bootstrap.rtl.min.css', array(), $theme_version, 'all');
    wp_enqueue_script('bootstrap-js', get_template_directory_uri() . '/assets/bootstrap/js/bootstrap.bundle.min.js', array('jquery'), $theme_version, true);

    // Uicons CSS
    wp_enqueue_style('uicons-css', get_template_directory_uri() . '/assets/icons/uicons-thin-rounded.css', array(), $theme_version, 'all');

    // Global CSS
    wp_enqueue_style('global-css', get_template_directory_uri() . '/css/global.css', ['bootstrap-css'], $theme_version);
}
add_action('wp_enqueue_scripts', 'ea_enqueue_assets');

function register_custom_page_templates($templates) {
    $custom_templates = array(
        'templates/dashboard-template.php' => 'Dashboard',
        'templates/users-template.php' => 'Users',
        'templates/login-template.php' => 'Login'
    );

    return array_merge($templates, $custom_templates);
}
add_filter('theme_page_templates', 'register_custom_page_templates');

function load_custom_page_template($template) {
    global $post;
    if (!$post) return $template;

    $custom_template = get_post_meta($post->ID, '_wp_page_template', true);

    if ($custom_template && file_exists(get_template_directory() . '/' . $custom_template)) {
        return get_template_directory() . '/' . $custom_template;
    }

    return $template;
}
add_filter('template_include', 'load_custom_page_template');

function enqueue_templates_assets() {
    if (is_page_template('templates/dashboard-template.php')) {

        wp_enqueue_style('dashboard-style', get_template_directory_uri() . '/css/dashboard.css');
        wp_enqueue_script('dashboard-script', get_template_directory_uri() . '/js/dashboard.js', ['jquery'], null, true);

    } elseif (is_page_template('templates/login-template.php')) {

        wp_enqueue_script('login-script', get_template_directory_uri() . '/js/login.js', ['jquery'], null, true);
        wp_localize_script('login-script', 'loginSettings', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('login_nonce'),
        ]);

        wp_enqueue_style('login-style', get_template_directory_uri() . '/css/login.css');

    } elseif (is_page_template('templates/users-template.php')) {
        wp_enqueue_style('dashboard-style', get_template_directory_uri() . '/css/dashboard.css');
        wp_enqueue_script('dashboard-script', get_template_directory_uri() . '/js/dashboard.js', ['jquery'], null, true);
    }
}
add_action('wp_enqueue_scripts', 'enqueue_templates_assets');

/**
 * Allow additional file types for uploads
 */
function allow_additional_file_types($mimes) {
    // Images
    $mimes['heic'] = 'image/heic';
    $mimes['heif'] = 'image/heif';
    $mimes['webp'] = 'image/webp';
    
    // Videos
    $mimes['webm'] = 'video/webm';
    $mimes['mkv'] = 'video/x-matroska';
    
    // Audio
    $mimes['m4a'] = 'audio/mp4';
    $mimes['aac'] = 'audio/aac';
    $mimes['flac'] = 'audio/flac';
    
    // Archives
    $mimes['rar'] = 'application/vnd.rar';
    $mimes['7z'] = 'application/x-7z-compressed';
    $mimes['tar'] = 'application/x-tar';
    $mimes['gz'] = 'application/gzip';
    
    // 3D & CAD
    $mimes['stl'] = 'application/vnd.ms-pki.stl';
    $mimes['fly'] = 'text/vnd.fly';
    
    // Documents
    $mimes['doc'] = 'application/msword';
    $mimes['docx'] = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
    $mimes['xls'] = 'application/vnd.ms-excel';
    $mimes['xlsx'] = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet';
    $mimes['ppt'] = 'application/vnd.ms-powerpoint';
    $mimes['pptx'] = 'application/vnd.openxmlformats-officedocument.presentationml.presentation';
    $mimes['csv'] = 'text/csv';
    $mimes['rtf'] = 'application/rtf';
    
    return $mimes;
}
add_filter('upload_mimes', 'allow_additional_file_types');
