jQuery(document).ready(function($) {

    const $eaLoginTitle = $("#ea_login_title");
    const $exsitsPhone = $("#ea_exists_phone");
    const $existsVerification = $("#ea_exists_verification");
    const $existsSubmit = $("#ea_exists_submit");
    const $loginWrapper = $('.ea_login_wrapper');

    // Phone Input EventListeners
    $exsitsPhone.on("input", function(e) {
        
        let input = this;
        let value = input.value.replace(/[^\d]/g, ""); // Only digits
        let $parent = $exsitsPhone.closest(".ea_login_field");

        // Enforce max 11 digits
        if (value.length > 11) {
            value = value.slice(0, 11);
        }

        // Auto-correct if starts with 9
        if (value.length === 1 && value.startsWith("9")) {
            value = "09";
        }

        input.value = value;

        // Reset classes
        $parent.removeClass("ea_accepted ea_rejected");

        // Validate structure
        if (value.length === 1) {
            if (!["0", "9"].includes(value.charAt(0))) {
                $parent.addClass("ea_rejected");
            }
        } else if (value.length >= 2 && value.length < 11) {
            if (!value.startsWith("09")) {
                $parent.addClass("ea_rejected");
            }
        } else if (value.length === 11) {
            if (value.startsWith("09")) {
                $parent.addClass("ea_accepted");

                // Only focus if not from deletion
                if (!(e.originalEvent && ["deleteContentBackward", "deleteContentForward"].includes(e.originalEvent.inputType))) {
                    $existsVerification.focus().select();
                }
            } else {
                $parent.addClass("ea_rejected");
            }

        }

        validateExistsForm();
    });

    // Handle floating label for phone field
    $exsitsPhone.on("focus blur", function() {
        let $parent = $(this).closest(".ea_floating_field");
        if ($(this).val() !== "" || $(this).is(":focus")) {
            $parent.addClass("ea_floating_active");
        } else {
            $parent.removeClass("ea_floating_active");
        }
    });

    // Verification Input Events
    $existsVerification.on("input", function () {
        let verifyValue = this.value;
    
        let $verifyParent = $existsVerification.closest(".ea_login_field");
        $verifyParent.removeClass("ea_accepted ea_rejected");
    
        // Digits only
        if (!/^\d*$/.test(verifyValue)) {
            this.value = verifyValue.replace(/[^\d]/g, "");
        }
    
        validateExistsForm();

        if (this.value.length === 4) {
            $existsSubmit.click();
        }
    });
    
    $existsVerification.on("blur", function () {
        const valueLength = this.value.length;
        const $verifyParent = $existsVerification.closest(".ea_login_field");

        if (valueLength >= 1 && valueLength < 4) {
            $verifyParent.addClass("ea_rejected");
        } else if (valueLength === 0) {
            $verifyParent.removeClass("ea_rejected");
        }

        validateExistsForm();
    });

    // Handle floating label for verification field
    $existsVerification.on("focus blur", function() {
        let $parent = $(this).closest(".ea_floating_field");
        if ($(this).val() !== "" || $(this).is(":focus")) {
            $parent.addClass("ea_floating_active");
        } else {
            $parent.removeClass("ea_floating_active");
        }
    });

    function validateExistsForm() {
        const phoneVal = $exsitsPhone.val();
        const verifyVal = $existsVerification.val();

        const isPhoneValid = phoneVal.length === 11 && phoneVal.startsWith("09");
        const isVerifyValid = verifyVal.length === 4 && /^\d{4}$/.test(verifyVal);

        return { isPhoneValid, isVerifyValid };
    }

    // Verification Image
    const $verificationWrapper = $("#ea_exists_verification_wrapper");
    const $verificationImg = $("#ea_exists_verification_wrapper img");
    const $verificationRefresh = $("#ea_exists_verification_refresh");

    function generateRandom() {
        $verificationWrapper.addClass("ea_loading");
        $verificationImg.hide();

        $.post(loginSettings.ajax_url, {
            action: "generateNumericCaptcha"
        }, function(response) {
            $verificationImg.attr("src", response.source).show();
            $verificationWrapper.removeClass("ea_loading");
        }, "json");
    }

    generateRandom();
    validateExistsForm();

    // Refresh Verification
    $verificationImg.on("click", function(e) {
        e.preventDefault();
        $existsVerification.val('');
        generateRandom();
        // Focus on verification field
        $existsVerification.focus();
        validateExistsForm();
    });
    $verificationRefresh.on("click", function(e) {
        e.preventDefault();
        $existsVerification.val('');
        generateRandom();
        // Focus on verification field
        $existsVerification.focus();
        validateExistsForm();
    });

    // Exists Form Submit
    $("#ea_exists_form").on("submit", function(event) {

        event.preventDefault();

        const phoneValue = $exsitsPhone.val();
        const verificationValue = $existsVerification.val();
        const $verifyParent = $existsVerification.closest(".ea_login_field");
        const $phoneParent = $exsitsPhone.closest(".ea_login_field");

        const { isPhoneValid, isVerifyValid } = validateExistsForm();

        let hasError = false;

        if (!isPhoneValid) {
            $phoneParent.addClass("ea_rejected");
            hasError = true;
        } else {
            $phoneParent.removeClass("ea_rejected").addClass("ea_accepted");
        }

        if (!isVerifyValid) {
            $verifyParent.addClass("ea_rejected");
            hasError = true;
        } else {
            $verifyParent.removeClass("ea_rejected").addClass("ea_accepted");
        }

        if (hasError) {
            return;
        }

        $loginWrapper.addClass("ea_login_loading");
        $("#ea_exists_message").html("").hide();

        let imageRecaptcha = verificationValue;

        $.post(loginSettings.ajax_url, {
            action: "ea_login_exists",
            phone: phoneValue,
            nonce: loginSettings.nonce,
            image_recaptcha: imageRecaptcha,
        }, function(response) {
            if (response.validate) {

                let combinedContent = $loginWrapper.html() + response.form;
                $loginWrapper.html(combinedContent);

                $("#ea_exists_form").remove();

                if (response.exists) {
                    handleLogin(phoneValue);
                    $("#ea_login_title").text("ورود به اتیوس");
                    $(".ea_login_subtitle").html("لطفا رمز عبور خود را برای شماره <span class='ea_login_number_value'>" + phoneValue + "</span> وارد نمایید یا از طریق کد یکبار مصرف وارد شوید.");
                } else {
                    generateOtp(phoneValue, 'new');
                    $("#ea_login_title").text("کد تایید را وارد کنید");
                    $(".ea_login_subtitle").html("حساب کاربری با شماره موبایل <span class='ea_login_number_value'>" + phoneValue + "</span> وجود ندارد. برای ساخت حساب جدید، کد تایید برای این شماره ارسال گردید.");
                    $("#otp_submit").val("عضویت");
                }

            } else {
                $loginWrapper.removeClass("ea_login_loading");
                $("#ea_exists_message").text(response.message).show();
                $verifyParent.addClass("ea_rejected");
                $verificationRefresh.click();
                validateExistsForm();
            }
        }, "json");
    });

    // Login Form Handler
    window.handleLogin = function(phone) {

        const $loginForm = $("#ea_login_form");

        $loginWrapper.removeClass("ea_login_loading");
        $loginForm.show();

        $("#ea_login_title").text("ورود به اتیوس");
        $(".ea_login_subtitle").html("کد تایید برای شماره <span class='ea_login_number_value'>" + phone + "</span> پیامک شد");
        
        $passwordInput = $("#ea_login_password");
        $passwordInput.focus();
        
        $("#ea_login_password_toggle").on("click", function(e) {
            e.preventDefault();
            if ($passwordInput.attr("type") === "password") {
                $passwordInput.attr("type", "text");
                $("#ea_login_password_toggle").addClass("ea_show_password");
            } else {
                $passwordInput.attr("type", "password");
                $("#ea_login_password_toggle").removeClass("ea_show_password");
            }
        });

        $("#ea_login_password").on("input", function(e) {
            if ($(this).val().trim() !== "") {
                $("#ea_login_submit").removeAttr("disabled");
            } else {
                $("#ea_login_submit").attr("disabled", true);
            }
        });

        // Handle floating label for password field
        $("#ea_login_password").on("focus blur", function() {
            let $parent = $(this).closest(".ea_floating_field");
            if ($(this).val() !== "" || $(this).is(":focus")) {
                $parent.addClass("ea_floating_active");
            } else {
                $parent.removeClass("ea_floating_active");
            }
        });

        $loginForm.on("submit", function(event) {
            event.preventDefault();
            $loginWrapper.addClass("ea_login_loading");
            $("#ea_login_message").html("").hide();

            $.post(loginSettings.ajax_url, {
                action: "ea_login_login",
                phone: phone,
                password: this.password.value
            }, function(response) {
                if (response.loggedin) {
                    window.location.href = response.redirecturl;
                } else {
                    $loginWrapper.removeClass("ea_login_loading");
                    $("#ea_login_message").text(response.message).show();
                }
            }, "json");
        });

        $("#ea_btn_loginOtp").on("click", function(e) {
            e.preventDefault();
            generateOtp(phone, "exists");
            $loginForm.hide();
            $loginWrapper.addClass("ea_login_loading");
        });

        $("#ea_btn_forgetPass").on("click", function(e) {
            e.preventDefault();
            generateOtp(phone, "forget");
            $loginForm.hide();
            $loginWrapper.addClass("ea_login_loading");
        });
    };

    // Generate OTP
    window.generateOtp = function(phone, user) {

        $.post(loginSettings.ajax_url, {
            action: "ea_login_otp_generator",
            phone: phone,
            user: user
        }, function(response) {
            if (!response.generated) {
                $loginWrapper.removeClass("ea_login_loading");
                $("#ea_otp_message").text(response.message).show();
            } else {
                setTimeout(() => {
                    handleOtp(phone, user);
        
                    // Update subtitle based on user type
                    // if (user === 'new') {
                    //     $(".ea_login_subtitle").html("حساب کاربری با شماره موبایل <span class='ea_login_number_value'>" + phone + "</span> وجود ندارد. برای ساخت حساب جدید، کد تایید برای این شماره ارسال گردید.");
                    // } else {
                    //     $(".ea_login_subtitle").html("کد تایید برای شماره <span class='ea_login_number_value'>" + phone + "</span> پیامک شد");
                    // }
        
                    startCountdownTimer();
                }, 1000);
            }
        }, "json");

    };

    // Countdown timer function
    let countdownTimer = null;
    function startCountdownTimer() {
        // Clear any existing timer
        if (countdownTimer) {
            clearInterval(countdownTimer);
        }
        
        let countdownTime = 120
        const $resendBtn = $('#ea_btn_resendOtp');
        countdownTimer = setInterval(() => {
            $resendBtn.prop('disabled', true);
            let minutes = String(Math.floor(countdownTime / 60)).padStart(2, '0');
            let seconds = String(countdownTime % 60).padStart(2, '0');
            $resendBtn.text(`ارسال مجدد کد ( ${minutes}:${seconds} )`);
            countdownTime--;
            if (countdownTime < 0) {
                clearInterval(countdownTimer);
                countdownTimer = null;
                $resendBtn.prop('disabled', false).text('ارسال مجدد کد');
            }
        }, 1000);
    }

    // OTP Handler
    let isHandlingOtp = false;
    window.handleOtp = function(phone, user) {
        
        // Prevent multiple simultaneous calls
        if (isHandlingOtp) {
            return;
        }
        isHandlingOtp = true;

        $loginWrapper.removeClass("ea_login_loading");
        
        const $otpForm = $("#ea_otp_form");
        const $otpSubmit = $("#ea_otp_submit");

        $otpForm.show();
        $("#ea_login_title").text("کد تایید را وارد کنید");
        // $(".ea_login_subtitle").html("کد تایید برای شماره <span class='ea_login_number_value'>" + phone + "</span> پیامک شد");

        // Update subtitle based on user type
        if (user === 'new') {
            $(".ea_login_subtitle").html("حساب کاربری با شماره موبایل <span class='ea_login_number_value'>" + phone + "</span> وجود ندارد. برای ساخت حساب جدید، کد تایید برای این شماره ارسال گردید.");
        } else {
            $(".ea_login_subtitle").html("کد تایید برای شماره <span class='ea_login_number_value'>" + phone + "</span> پیامک شد");
        }

        // Initialize OTP inputs
        const $otpInputs = $('.ea_otp_input');
        const $hiddenOtpInput = $("#ea_login_otp");
        
        // Clear all inputs
        $otpInputs.val('').removeClass('filled error');
        $otpInputs.first().focus();

        // Handle OTP input events
        $otpInputs.on('input', function(e) {
            const $current = $(this);
            const value = $current.val();
            const index = parseInt($current.data('index'));
            
            // Only allow digits
            if (!/^\d*$/.test(value)) {
                $current.val(value.replace(/[^\d]/g, ''));
                return;
            }
            
            // Remove error state
            $current.removeClass('error');
            
            // Add filled class if has value
            if (value) {
                $current.addClass('filled');
            } else {
                $current.removeClass('filled');
            }
            
            // Auto-focus next input
            if (value && index < 5) {
                $otpInputs.eq(index + 1).focus();
            }
            
            // Update hidden input and check if complete
            updateHiddenOtpInput();
        });

        // Handle backspace
        $otpInputs.on('keydown', function(e) {
            const $current = $(this);
            const index = parseInt($current.data('index'));
            
            if (e.key === 'Backspace' && !$current.val() && index > 0) {
                $otpInputs.eq(index - 1).focus();
            }
        });

        // Handle paste
        $otpInputs.on('paste', function(e) {
            e.preventDefault();
            const pastedData = (e.originalEvent.clipboardData || window.clipboardData).getData('text');
            const digits = pastedData.replace(/[^\d]/g, '').slice(0, 6);
            
            if (digits.length > 0) {
                digits.split('').forEach((digit, i) => {
                    if (i < 6) {
                        $otpInputs.eq(i).val(digit).addClass('filled');
                    }
                });
                updateHiddenOtpInput();
                
                // Focus the next empty input or the last one
                const nextEmptyIndex = digits.length < 6 ? digits.length : 5;
                $otpInputs.eq(nextEmptyIndex).focus();
            }
        });

        // Handle arrow keys and other navigation
        $otpInputs.on('keydown', function(e) {
            const $current = $(this);
            const index = parseInt($current.data('index'));
            
            if (e.key === 'ArrowLeft' && index > 0) {
                $otpInputs.eq(index - 1).focus();
            } else if (e.key === 'ArrowRight' && index < 5) {
                $otpInputs.eq(index + 1).focus();
            } else if (e.key === 'Delete' && $current.val()) {
                $current.val('').removeClass('filled');
                updateHiddenOtpInput();
            } else if (e.key === 'Escape') {
                // Clear all inputs on escape
                $otpInputs.val('').removeClass('filled error');
                $("#ea_login_otp").val('');
                $otpInputs.first().focus();
                updateHiddenOtpInput();
            }
        });

        // Handle click on OTP container to focus first empty input
        $('.ea_otp_input_container').on('click', function() {
            const firstEmpty = $otpInputs.filter(function() {
                return !$(this).val();
            }).first();
            
            if (firstEmpty.length) {
                firstEmpty.focus();
            } else {
                $otpInputs.first().focus();
            }
        });

        // Function to update hidden input
        function updateHiddenOtpInput() {
            const otpValue = $otpInputs.map(function() {
                return $(this).val();
            }).get().join('');
            
            $hiddenOtpInput.val(otpValue);
            
            if (otpValue.length === 6) {
                $otpSubmit.prop('disabled', false);
                // Auto-submit after a short delay
                setTimeout(() => {
                    $otpSubmit.click();
                }, 300);
            } else {
                $otpSubmit.prop('disabled', true);
            }
        }

        // Remove any existing event listeners to prevent duplication
        $("#ea_btn_resendOtp").off("click");
        $("#ea_btn_resendOtp").on("click", function(e) {
            e.preventDefault();
            
            // Prevent rapid clicking
            if ($(this).prop('disabled')) {
                return;
            }
            
            generateOtp(phone, user);
        });

        $("#ea_btn_changeNumber").on("click", function(e) {
            e.preventDefault();
            isHandlingOtp = false; // Reset flag
            location.reload();
        });

        $otpForm.on("submit", function(event) {
            event.preventDefault();

            $loginWrapper.addClass("ea_login_loading");
            $("#ea_otp_message").html("").hide();

            $.post(loginSettings.ajax_url, {
                action: "ea_login_otp",
                phone: phone,
                otp: $("#ea_login_otp").val(),
                user: user
            }, function(response) {
                if (response.loggedin) {
                    isHandlingOtp = false; // Reset flag
                    window.location.href = response.redirecturl;
                } else {
                    $loginWrapper.removeClass("ea_login_loading");
                    $("#ea_otp_message").text(response.message).show();
                    
                    // Add error state to OTP inputs
                    $('.ea_otp_input').addClass('error');
                    setTimeout(() => {
                        $('.ea_otp_input').removeClass('error');
                        $('.ea_otp_input').val('').removeClass('filled');
                        $("#ea_login_otp").val('');
                        $('.ea_otp_input').first().focus();
                    }, 2000);
                }
            }, "json");
        });
    };

});
