<?php
/**
 * Client Dashboard Template
 * 
 * Specific dashboard for users with 'Client' role
 */

get_header();

// Enqueue dashboard styles
wp_enqueue_style('dashboard-styles', get_template_directory_uri() . '/css/dashboard.css', array(), '1.0.0');
wp_enqueue_style('new-order-styles', get_template_directory_uri() . '/css/new-order.css', array(), '1.0.0');
wp_enqueue_style('orders-styles', get_template_directory_uri() . '/css/orders.css', array(), '1.0.0');

// wp_enqueue_style('persian-datepicker-css', get_template_directory_uri() . '/assets/DatePicker/dist/css/persian-datepicker.css', array(), '1.0.0');

// Enqueue dashboard scripts
wp_enqueue_script('dental-file-upload', get_template_directory_uri() . '/js/file-upload-component.js', array(), '1.0.0', true);
wp_enqueue_script('dashboard-scripts', get_template_directory_uri() . '/js/dashboard.js', array(), '1.0.0', true);
wp_enqueue_script('new-order-scripts', get_template_directory_uri() . '/js/new-order.js', array('dental-file-upload'), '1.0.0', true);

wp_enqueue_script('persian-date', get_template_directory_uri() . '/assets/PersianDate/dist/persian-date.js', array(), '1.0.0', true);
// wp_enqueue_script('persian-datepicker-js', get_template_directory_uri() . '/assets/DatePicker/dist/js/persian-datepicker.js', array(), '1.0.0', true);

wp_enqueue_script('orders-scripts', get_template_directory_uri() . '/js/orders.js', array('persian-date'), '1.0.0', true);

// Localize new-order script
wp_localize_script('new-order-scripts', 'newOrderLocalization', array(
    'ajaxUrl' => admin_url('admin-ajax.php'),
    'userId' => get_current_user_id(),
    'nonces' => array(
        'dental_file_upload' => wp_create_nonce('dental_file_upload'),
        'dental_file_delete' => wp_create_nonce('dental_file_delete'),
        'dental_order_submit' => wp_create_nonce('dental_order_submit'),
        'get_user_dental_orders' => wp_create_nonce('get_user_dental_orders')
    )
));

// Localize orders script
wp_localize_script('orders-scripts', 'ordersLocalization', array(
    'ajaxUrl' => admin_url('admin-ajax.php'),
    'userId' => get_current_user_id(),
    'nonce' => wp_create_nonce('get_user_dental_orders')
));


$current_user = wp_get_current_user();
$user_role = etiuse_get_current_user_role();
$role_display_name = etiuse_get_role_display_name($user_role);
?>

<div class="dashboard-container">
    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebar-overlay"></div>
    
    <!-- Fixed Right Sidebar -->
    <aside class="dashboard-sidebar" id="dashboard-sidebar">
        <!-- Logo Section -->
        <div class="sidebar-logo">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/brand/logo-dark.png" alt="Logo" class="logo-image">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/brand/icon.png" alt="Icon" class="logo-icon">
        </div>
        
        <!-- Navigation Menu Section -->
        <nav class="sidebar-nav">
            <ul class="nav-menu">
                <li class="nav-item">
                    <a href="#dashboard" class="nav-link active" data-section="dashboard">
                        <i class="bi bi-house-door"></i>
                        <span class="nav-text"><?php _e('داشبورد', 'etiuse-lab'); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#new-order" class="nav-link" data-section="new-order">
                        <i class="bi bi-plus-circle"></i>
                        <span class="nav-text"><?php _e('سفارش جدید', 'etiuse-lab'); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#orders" class="nav-link" data-section="orders">
                        <i class="bi bi-list-ul"></i>
                        <span class="nav-text"><?php _e('سفارشات', 'etiuse-lab'); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="#charges" class="nav-link" data-section="charges">
                        <i class="bi bi-credit-card"></i>
                        <span class="nav-text"><?php _e('شارژ حساب', 'etiuse-lab'); ?></span>
                    </a>
                </li>
            </ul>
        </nav>
        
        <!-- User Account Section (Fixed at bottom) -->
        <div class="sidebar-account">
            <div class="user-profile">
                <div class="user-avatar">
                    <i class="bi bi-person"></i>
                </div>
                <div class="user-info">
                    <?php 
                    $first_name = get_user_meta($current_user->ID, 'first_name', true);
                    $last_name = get_user_meta($current_user->ID, 'last_name', true);
                    $full_name = trim($first_name . ' ' . $last_name);
                    if (empty($full_name)) {
                        $full_name = $current_user->display_name; // Fallback to display_name if first/last name not available
                    }
                    ?>
                    <div class="user-name"><?php echo esc_html($full_name); ?></div>
                    <?php 
                    $user_type = get_user_meta($current_user->ID, 'user_type', true);
                    if ($user_type): 
                        // Map user_type to Persian labels
                        $user_type_labels = array(
                            'Clinic' => 'مطب',
                            'Lab' => 'لابراتوار'
                        );
                        $user_type_label = isset($user_type_labels[$user_type]) ? $user_type_labels[$user_type] : $user_type;
                    ?>
                        <div class="user-type"><?php echo esc_html($user_type_label); ?></div>
                    <?php endif; ?>
                </div>
                <div class="user-settings">
                    <button class="settings-toggle" id="settings-toggle">
                        <i class="bi bi-gear"></i>
                    </button>
                    <div class="settings-dropdown" id="settings-dropdown">
                        <a href="<?php echo home_url('/p/account'); ?>" class="dropdown-item">
                            <i class="bi bi-person-circle"></i>
                            <span><?php _e('حساب کاربری', 'etiuse-lab'); ?></span>
                        </a>
                        <a href="#" class="dropdown-item">
                            <i class="bi bi-gear"></i>
                            <span><?php _e('تنظیمات', 'etiuse-lab'); ?></span>
                        </a>
                        <a href="#" class="dropdown-item">
                            <i class="bi bi-key"></i>
                            <span><?php _e('تغییر رمز عبور', 'etiuse-lab'); ?></span>
                        </a>
                        <a href="#" class="dropdown-item">
                            <i class="bi bi-headset"></i>
                            <span><?php _e('پشتیبانی', 'etiuse-lab'); ?></span>
                        </a>
                        <a href="<?php echo wp_logout_url(home_url()); ?>" class="dropdown-item logout">
                            <i class="bi bi-box-arrow-right"></i>
                            <span><?php _e('خروج از حساب کاربری', 'etiuse-lab'); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </aside>

    <!-- Main Content Area -->
    <main class="dashboard-main">
        <!-- Sticky Header -->
        <header class="dashboard-header">
            <div class="header-content">
                <div class="header-left">
                    <button class="sidebar-toggle" id="sidebar-toggle">
                        <i class="bi bi-list"></i>
                    </button>
                    <!-- Search Field (Desktop only) -->
                    <div class="header-search desktop-only">
                        <div class="search-field">
                            <i class="bi bi-search"></i>
                            <input type="text" placeholder="<?php _e('جستجو...', 'etiuse-lab'); ?>" class="search-input">
                        </div>
                    </div>
                </div>
                <div class="header-right">
                    <div class="header-actions">
                        <div class="header-icon support" title="<?php _e('پشتیبانی', 'etiuse-lab'); ?>">
                            <i class="bi bi-headset"></i>
                        </div>
                        <div class="header-icon search mobile-search" title="<?php _e('جستجو', 'etiuse-lab'); ?>">
                            <i class="bi bi-search"></i>
                        </div>
                        <div class="header-icon theme-switch" title="<?php _e('تغییر تم', 'etiuse-lab'); ?>">
                            <i class="bi bi-moon"></i>
                        </div>
                        <div class="header-icon notifications" title="<?php _e('اعلان‌ها', 'etiuse-lab'); ?>">
                            <i class="bi bi-bell"></i>
                            <span class="badge">3</span>
                        </div>
                    </div>
                </div>
            </div>
        </header>


        <!-- Main Content -->
        <div class="dashboard-content">

            <!-- Dashboard Section (Default) -->
            <div id="dashboard-section" class="content-section active">
                <div class="section-title-bar">
                    <h1><?php _e('به پنل کاربری اتیوس خوش آمدید', 'etiuse-lab'); ?></h1>
                    <p><?php _e('صفحه اصلی داشبورد شما - آمار، فعالیت‌های اخیر و دسترسی سریع', 'etiuse-lab'); ?></p>
                </div>
                <!-- Quick Stats Cards -->
                <div class="stats-grid">
                    <div class="stat-card">
                        <div class="stat-icon bg-primary">
                            <i class="bi bi-calendar-check"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">0</div>
                            <p><?php _e('نوبت‌های فعال', 'etiuse-lab'); ?></p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon bg-success">
                            <i class="bi bi-file-medical"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">0</div>
                            <p><?php _e('سوابق پزشکی', 'etiuse-lab'); ?></p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon bg-warning">
                            <i class="bi bi-credit-card"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">0</div>
                            <p><?php _e('پرداخت‌های در انتظار', 'etiuse-lab'); ?></p>
                        </div>
                    </div>
                    
                    <div class="stat-card">
                        <div class="stat-icon bg-info">
                            <i class="bi bi-envelope"></i>
                        </div>
                        <div class="stat-info">
                            <div class="stat-number">0</div>
                            <p><?php _e('پیام‌های جدید', 'etiuse-lab'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Content Sections -->
                <div class="content-grid">
                    <!-- Quick Actions -->
                    <div class="content-card">
                        <div class="card-body">
                            <div class="quick-actions">
                                <a href="#new-order" class="action-btn">
                                    <i class="bi bi-calendar-plus"></i>
                                    <span><?php _e('سفارش جدید', 'etiuse-lab'); ?></span>
                                </a>
                                <a href="#orders" class="action-btn">
                                    <i class="bi bi-file-text"></i>
                                    <span><?php _e('مشاهده سفارشات', 'etiuse-lab'); ?></span>
                                </a>
                                <a href="#charges" class="action-btn">
                                    <i class="bi bi-headset"></i>
                                    <span><?php _e('شارژ حساب', 'etiuse-lab'); ?></span>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Recent Activity -->
                    <div class="content-card">
                        <div class="card-body">
                            <div class="activity-list">
                                <div class="activity-item">
                                    <div class="activity-icon">
                                        <i class="bi bi-clock"></i>
                                    </div>
                                    <div class="activity-content">
                                        <p><?php _e('آخرین ورود', 'etiuse-lab'); ?></p>
                                        <small><?php echo date_i18n('Y/m/d H:i'); ?></small>
                                    </div>
                                </div>
                                <div class="activity-item">
                                    <div class="activity-icon">
                                        <i class="bi bi-check-circle"></i>
                                    </div>
                                    <div class="activity-content">
                                        <p><?php _e('وضعیت حساب', 'etiuse-lab'); ?></p>
                                        <span class="status-badge active"><?php _e('فعال', 'etiuse-lab'); ?></span>
                                    </div>
                                </div>
                                <div class="activity-item">
                                    <div class="activity-icon">
                                        <i class="bi bi-calendar"></i>
                                    </div>
                                    <div class="activity-content">
                                        <p><?php _e('تاریخ عضویت', 'etiuse-lab'); ?></p>
                                        <small><?php echo date_i18n('Y/m/d', strtotime($current_user->user_registered)); ?></small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Upcoming Appointments -->
                <div class="content-card full-width">
                    <div class="card-body">
                        <div class="empty-state">
                            <i class="bi bi-calendar-x"></i>
                            <p><?php _e('هیچ نوبتی برای نمایش وجود ندارد.', 'etiuse-lab'); ?></p>
                            <a href="#new-order" class="btn btn-primary">
                                <?php _e('سفارش جدید', 'etiuse-lab'); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- New Order Section -->
            <div id="new-order-section" class="content-section">
                <div class="section-title-bar">
                    <h1><?php _e('سفارش جدید', 'etiuse-lab'); ?></h1>
                    <p><?php _e('ثبت سفارش جدید برای خدمات دندانپزشکی - انتخاب خدمات، زیر خدمات و آپلود فایل‌ها', 'etiuse-lab'); ?></p>
                </div>
                <div class="content-card full-width">
                    <div class="card-body">
                        <form id="new-order-form" method="post" action="">
                            <!-- Hidden Fields -->
                            <input type="hidden" name="user_id" value="<?php echo get_current_user_id(); ?>">
                            
                            <!-- Progress Bar -->
                            <div class="order-progress">
                                <div class="progress-steps">
                                    <div class="progress-step active" data-step="1">
                                        <div class="step-number">1</div>
                                        <div class="step-label">خدمات</div>
                                        <div class="step-summary"></div>
                                    </div>
                                    <div class="progress-step" data-step="2">
                                        <div class="step-number">2</div>
                                        <div class="step-label">زیر خدمات</div>
                                        <div class="step-summary"></div>
                                    </div>
                                    <div class="progress-step" data-step="3">
                                        <div class="step-number">3</div>
                                        <div class="step-label">دستور کار</div>
                                        <div class="step-summary"></div>
                                    </div>
                                    <div class="progress-step" data-step="4">
                                        <div class="step-number">4</div>
                                        <div class="step-label">تصاویر و فایل ها</div>
                                        <div class="step-summary"></div>
                                    </div>
                                </div>
                                <div class="progress-bar">
                                    <div class="progress-fill"></div>
                                </div>
                            </div>

                            <!-- Form Steps -->
                            <div class="order-form">
                                <!-- Step 1: Services -->
                                <div class="form-step active" data-step="1">
                                    <div class="step-content">
                                        <div class="step-title">انتخاب خدمات</div>
                                        <p>لطفاً نوع خدمات مورد نیاز خود را انتخاب کنید.</p>
                                        
                                        <div class="service-field">
                                            <div class="field-title">نوع خدمات</div>
                                            <div class="field-options">
                                                <div class="field-option">
                                                    <input type="radio" id="service_orthodontics" name="service_type" value="orthodontics" required>
                                                    <label for="service_orthodontics" class="option-card">
                                                        <div class="option-info">
                                                            <small>Orthodontics</small>
                                                            <div class="option-title">ارتودنسی</div>
                                                            <div class="option-description">تصحیح و مرتب کردن دندان‌ها و فک</div>
                                                        </div>
                                                    </label>
                                                </div>
                                                
                                                <div class="field-option">
                                                    <input type="radio" id="service_fixed" name="service_type" value="fixed_prosthesis" required>
                                                    <label for="service_fixed" class="option-card">
                                                        <div class="option-info">
                                                            <small>Fixed Prosthesis</small>
                                                            <div class="option-title">پروتز ثابت</div>
                                                            <div class="option-description">روکش، بریج و ایمپلنت ثابت</div>
                                                        </div>
                                                    </label>
                                                </div>
                                                
                                                <div class="field-option">
                                                    <input type="radio" id="service_removable" name="service_type" value="removable_prosthesis" required>
                                                    <label for="service_removable" class="option-card">
                                                        <div class="option-info">
                                                            <small>Removable Prosthesis</small>
                                                            <div class="option-title">پروتز متحرک</div>
                                                            <div class="option-description">دندان مصنوعی قابل برداشت</div>
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Step 2: Sub-services -->
                                <div class="form-step" data-step="2">
                                    <div class="step-content">
                                        <div class="step-title">انتخاب زیر خدمات</div>
                                        <p>زیر خدمات مورد نیاز خود را انتخاب کنید.</p>
                                        
                                        <!-- Skip Step Box -->
                                        <div class="skip-step-box">
                                            <div class="skip-step-content">
                                                <div class="skip-step-text">
                                                    <i class="bi bi-info-circle"></i>
                                                    <span>اگر در انتخاب زیر خدمات مطمئن نیستید، این مرحله را رد کنید و متخصصان ما آن را برای شما تکمیل می‌کنند.</span>
                                                </div>
                                                <button type="button" class="btn btn-outline-secondary skip-step-btn" id="skip_step_2">
                                                    رد کردن این مرحله
                                                    <i class="bi bi-arrow-left"></i>
                                                </button>
                                            </div>
                                        </div>
                                        
                                        <div class="sub-services-container">
                                            <!-- Orthodontics Type (Field 1) - Show when option 1 is selected -->
                                            <div class="service-field" id="field_1" style="display: none;">
                                                <div class="field-title">نوع ارتودنسی</div>
                                                <div class="field-subtitle">Orthodontics Type</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="ortho_clear_aligner" name="orthodontics_type" value="clear_aligner" required>
                                                        <label for="ortho_clear_aligner" class="option-card">
                                                            <div class="option-info">
                                                                <small>Clear Aligner</small>
                                                                <div class="option-title">ارتودنسی شفاف</div>
                                                                <div class="option-description">استفاده از پلاک‌های شفاف برای مرتب کردن دندان‌ها</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="ortho_retainer" name="orthodontics_type" value="orthodontic_retainer" required>
                                                        <label for="ortho_retainer" class="option-card">
                                                            <div class="option-info">
                                                                <small>Orthodontic Retainer</small>
                                                                <div class="option-title">پلاک ارتودنسی</div>
                                                                <div class="option-description">نگهدارنده دندان‌ها پس از اتمام درمان ارتودنسی</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="ortho_surgery" name="orthodontics_type" value="orthognathic_surgery" required>
                                                        <label for="ortho_surgery" class="option-card">
                                                            <div class="option-info">
                                                                <small>Orthognathic Surgery</small>
                                                                <div class="option-title">ارتو سرجری</div>
                                                                <div class="option-description">جراحی فک برای اصلاح مشکلات اسکلتی صورت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="ortho_diagnosis" name="orthodontics_type" value="diagnosis_analysis" required>
                                                        <label for="ortho_diagnosis" class="option-card">
                                                            <div class="option-info">
                                                                <small>Diagnosis & Analysis</small>
                                                                <div class="option-title">آنالیز و تشخیص</div>
                                                                <div class="option-description">بررسی و تحلیل وضعیت دندان‌ها و فک برای برنامه‌ریزی درمان</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Fixed Prosthesis (Field 2) - Show when option 2 is selected -->
                                            <div class="service-field" id="field_2" style="display: none;">
                                                <div class="field-title">پروتز ثابت</div>
                                                <div class="field-subtitle">Fixed Prosthesis</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="fixed_crown" name="fixed_prosthesis" value="crown" required>
                                                        <label for="fixed_crown" class="option-card">
                                                            <div class="option-info">
                                                                <small>Crown</small>
                                                                <div class="option-title">روکش</div>
                                                                <div class="option-description">پوشش کامل دندان برای محافظت و زیبایی</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="fixed_abutment" name="fixed_prosthesis" value="abutment" required>
                                                        <label for="fixed_abutment" class="option-card">
                                                            <div class="option-info">
                                                                <small>Abutment</small>
                                                                <div class="option-title">اباتمنت</div>
                                                                <div class="option-description">اتصال‌دهنده بین ایمپلنت و پروتز</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="fixed_laminate" name="fixed_prosthesis" value="laminate" required>
                                                        <label for="fixed_laminate" class="option-card">
                                                            <div class="option-info">
                                                                <small>Laminate (Veneer)</small>
                                                                <div class="option-title">لمینت</div>
                                                                <div class="option-description">پوشش نازک سرامیکی روی سطح دندان</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="fixed_substructure" name="fixed_prosthesis" value="substructure" required>
                                                        <label for="fixed_substructure" class="option-card">
                                                            <div class="option-info">
                                                                <small>Fixed Substructure</small>
                                                                <div class="option-title">ساب استراکچر فیکس</div>
                                                                <div class="option-description">اسکلت فلزی زیر روکش برای استحکام بیشتر</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="fixed_composite" name="fixed_prosthesis" value="composite_restoration" required>
                                                        <label for="fixed_composite" class="option-card">
                                                            <div class="option-info">
                                                                <small>Indirect Composite Restoration</small>
                                                                <div class="option-title">ایندایرکت کامپوزیت رستوریشن</div>
                                                                <div class="option-description">ترمیم دندان با کامپوزیت در لابراتوار</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="fixed_smile_design" name="fixed_prosthesis" value="smile_design" required>
                                                        <label for="fixed_smile_design" class="option-card">
                                                            <div class="option-info">
                                                                <small>Smile Design</small>
                                                                <div class="option-title">طراحی لبخند</div>
                                                                <div class="option-description">طراحی زیبایی لبخند با در نظر گرفتن تناسب صورت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Crown Type (Field 4) - Show when option 4 is selected -->
                                            <div class="service-field" id="field_4" style="display: none;">
                                                <div class="field-title">پروتز ثابت روکش</div>
                                                <div class="field-subtitle">Fixed Prosthesis – Crown</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="crown_pfm" name="crown_type" value="pfm" required>
                                                        <label for="crown_pfm" class="option-card">
                                                            <div class="option-info">
                                                                <small>Porcelain Fused to Metal</small>
                                                                <div class="option-title">PFM</div>
                                                                <div class="option-description">روکش با اسکلت فلزی و پوشش سرامیکی</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="crown_zirconia" name="crown_type" value="zirconia" required>
                                                        <label for="crown_zirconia" class="option-card">
                                                            <div class="option-info">
                                                                <small>Zirconia</small>
                                                                <div class="option-title">زیرکونیا</div>
                                                                <div class="option-description">روکش تمام سرامیک با استحکام بالا</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="crown_lithium" name="crown_type" value="lithium_disilicate" required>
                                                        <label for="crown_lithium" class="option-card">
                                                            <div class="option-info">
                                                                <small>Lithium Disilicate</small>
                                                                <div class="option-title">لیتیوم دی سیلکات</div>
                                                                <div class="option-description">سرامیک شیشه‌ای با شفافیت و استحکام بالا</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="crown_pmma" name="crown_type" value="pmma" required>
                                                        <label for="crown_pmma" class="option-card">
                                                            <div class="option-info">
                                                                <small>Polymethyl Methacrylate</small>
                                                                <div class="option-title">PMMA</div>
                                                                <div class="option-description">پلاستیک آکریلیک برای روکش‌های موقت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Zirconia Crown Type (Field 7) - Show when option 7 is selected -->
                                            <div class="service-field" id="field_7" style="display: none;">
                                                <div class="field-title">پروتز ثابت روکش زیرکونیا</div>
                                                <div class="field-subtitle">Fixed Prosthesis – Zirconia Crown</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="zirconia_implant" name="zirconia_type" value="implant" required>
                                                        <label for="zirconia_implant" class="option-card">
                                                            <div class="option-info">
                                                                <small>Implant</small>
                                                                <div class="option-title">ایمپلنت</div>
                                                                <div class="option-description">روکش روی پایه ایمپلنت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="zirconia_dental" name="zirconia_type" value="dental" required>
                                                        <label for="zirconia_dental" class="option-card">
                                                            <div class="option-info">
                                                                <small>Dental (Tooth-Supported)</small>
                                                                <div class="option-title">دندانی</div>
                                                                <div class="option-description">روکش روی دندان طبیعی</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- PMMA Crown Type (Field 8) - Show when option 8 is selected -->
                                            <div class="service-field" id="field_8" style="display: none;">
                                                <div class="field-title">پروتز ثابت روکش PMMA</div>
                                                <div class="field-subtitle">Fixed Prosthesis with PMMA Crown</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="pmma_temp_implant" name="pmma_type" value="temporary_implant" required>
                                                        <label for="pmma_temp_implant" class="option-card">
                                                            <div class="option-info">
                                                                <small>Temporary Implant</small>
                                                                <div class="option-title">ایمپلنت موقت</div>
                                                                <div class="option-description">روکش موقت روی ایمپلنت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="pmma_temp" name="pmma_type" value="temporary" required>
                                                        <label for="pmma_temp" class="option-card">
                                                            <div class="option-info">
                                                                <small>Temporary</small>
                                                                <div class="option-title">موقت</div>
                                                                <div class="option-description">روکش موقت روی دندان</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Abutment Type (Field 5) - Show when option 5 is selected -->
                                            <div class="service-field" id="field_5" style="display: none;">
                                                <div class="field-title">پروتز ثابت اباتمنت</div>
                                                <div class="field-subtitle">Fixed Prosthesis – Abutment</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="abutment_prep" name="abutment_type" value="preparation" required>
                                                        <label for="abutment_prep" class="option-card">
                                                            <div class="option-info">
                                                                <small>Preparation</small>
                                                                <div class="option-title">تراش</div>
                                                                <div class="option-description">تراش دندان برای قرار دادن اباتمنت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="abutment_custom" name="abutment_type" value="customized" required>
                                                        <label for="abutment_custom" class="option-card">
                                                            <div class="option-info">
                                                                <small>Customized</small>
                                                                <div class="option-title">کاستومایزد</div>
                                                                <div class="option-description">اباتمنت سفارشی برای شرایط خاص</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="abutment_selection" name="abutment_type" value="abutment_selection" required>
                                                        <label for="abutment_selection" class="option-card">
                                                            <div class="option-info">
                                                                <small>Abutment Selection</small>
                                                                <div class="option-title">انتخاب اباتمنت</div>
                                                                <div class="option-description">انتخاب اباتمنت مناسب از بین انواع موجود</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="abutment_jig" name="abutment_type" value="types_of_jig" required>
                                                        <label for="abutment_jig" class="option-card">
                                                            <div class="option-info">
                                                                <small>Types of Jig</small>
                                                                <div class="option-title">انواع جیگ</div>
                                                                <div class="option-description">ابزارهای مختلف برای قرار دادن اباتمنت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Laminate Type (Field 6) - Show when option 6 is selected -->
                                            <div class="service-field" id="field_6" style="display: none;">
                                                <div class="field-title">پروتز ثابت لمینت</div>
                                                <div class="field-subtitle">Fixed Prosthesis – Laminate</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="laminate_laminate" name="laminate_type" value="laminate" required>
                                                        <label for="laminate_laminate" class="option-card">
                                                            <div class="option-info">
                                                                <small>Laminate (Veneer)</small>
                                                                <div class="option-title">لمینت</div>
                                                                <div class="option-description">پوشش نازک سرامیکی روی سطح دندان</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="laminate_core" name="laminate_type" value="core_laminate" required>
                                                        <label for="laminate_core" class="option-card">
                                                            <div class="option-info">
                                                                <small>Core Laminate</small>
                                                                <div class="option-title">کور لمینت</div>
                                                                <div class="option-description">لمینت با هسته تقویتی برای استحکام بیشتر</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Laminate Laminate Type (Field 9) - Show when option 9 is selected -->
                                            <div class="service-field" id="field_9" style="display: none;">
                                                <div class="field-title">پروتز ثابت لمینت لمینت</div>
                                                <div class="field-subtitle">Fixed Prosthesis – Laminate (Laminate)</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="lam_lam_feldspathic" name="laminate_laminate_type" value="feldspathic" required>
                                                        <label for="lam_lam_feldspathic" class="option-card">
                                                            <div class="option-info">
                                                                <small>Feldspathic</small>
                                                                <div class="option-title">فلدسپاتیک</div>
                                                                <div class="option-description">سرامیک سنتی با شفافیت بالا</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="lam_lam_ips" name="laminate_laminate_type" value="ips" required>
                                                        <label for="lam_lam_ips" class="option-card">
                                                            <div class="option-info">
                                                                <small>IPS (Ivoclar Press System)</small>
                                                                <div class="option-title">ips</div>
                                                                <div class="option-description">سرامیک فشرده با استحکام و زیبایی بالا</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Core Laminate Type (Field 10) - Show when option 10 is selected -->
                                            <div class="service-field" id="field_10" style="display: none;">
                                                <div class="field-title">پروتز ثابت لمینت کور لمینت</div>
                                                <div class="field-subtitle">Fixed Prosthesis – Laminate (Core Laminate)</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="core_lam_core" name="core_laminate_type" value="core_laminate" required>
                                                        <label for="core_lam_core" class="option-card">
                                                            <div class="option-info">
                                                                <small>Core Laminate</small>
                                                                <div class="option-title">کور لمینت</div>
                                                                <div class="option-description">لمینت با هسته تقویتی برای استحکام بیشتر</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="core_lam_ips" name="core_laminate_type" value="ips" required>
                                                        <label for="core_lam_ips" class="option-card">
                                                            <div class="option-info">
                                                                <small>IPS (Ivoclar Press System)</small>
                                                                <div class="option-title">ips</div>
                                                                <div class="option-description">سرامیک فشرده با استحکام و زیبایی بالا</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Removable Prosthesis (Field 3) - Show when option 3 is selected -->
                                            <div class="service-field" id="field_3" style="display: none;">
                                                <div class="field-title">پروتز متحرک</div>
                                                <div class="field-subtitle">Removable Prosthesis</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="removable_denture" name="removable_prosthesis" value="denture" required>
                                                        <label for="removable_denture" class="option-card">
                                                            <div class="option-info">
                                                                <small>Denture</small>
                                                                <div class="option-title">دنچر</div>
                                                                <div class="option-description">دندان مصنوعی کامل قابل برداشت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="removable_partial" name="removable_prosthesis" value="partial" required>
                                                        <label for="removable_partial" class="option-card">
                                                            <div class="option-info">
                                                                <small>Partial</small>
                                                                <div class="option-title">پارسیل</div>
                                                                <div class="option-description">دندان مصنوعی جزئی قابل برداشت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Denture Type (Field 11) - Show when option 11 is selected -->
                                            <div class="service-field" id="field_11" style="display: none;">
                                                <div class="field-title">پروتز متحرک دنچر</div>
                                                <div class="field-subtitle">Removable Denture Prosthesis</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="denture_denture" name="denture_type" value="denture" required>
                                                        <label for="denture_denture" class="option-card">
                                                            <div class="option-info">
                                                                <small>Denture</small>
                                                                <div class="option-title">دنچر</div>
                                                                <div class="option-description">دندان مصنوعی کامل برای جایگزینی تمام دندان‌ها</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="denture_obturator" name="denture_type" value="obturator" required>
                                                        <label for="denture_obturator" class="option-card">
                                                            <div class="option-info">
                                                                <small>Obturator</small>
                                                                <div class="option-title">آبچوراتور</div>
                                                                <div class="option-description">پروتز برای بستن نقص در سقف دهان</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="denture_overdenture" name="denture_type" value="overdenture" required>
                                                        <label for="denture_overdenture" class="option-card">
                                                            <div class="option-info">
                                                                <small>Overdenture</small>
                                                                <div class="option-title">اوردنچر</div>
                                                                <div class="option-description">دندان مصنوعی روی ایمپلنت‌های موجود</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Partial Type (Field 12) - Show when option 12 is selected -->
                                            <div class="service-field" id="field_12" style="display: none;">
                                                <div class="field-title">پروتز متحرک پارسیل</div>
                                                <div class="field-subtitle">Partial Removable Prosthesis</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="partial_acrylic" name="partial_type" value="acrylic" required>
                                                        <label for="partial_acrylic" class="option-card">
                                                            <div class="option-info">
                                                                <small>Acrylic</small>
                                                                <div class="option-title">آکریلی</div>
                                                                <div class="option-description">پروتز پارسیل با پایه آکریلی</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="partial_metal" name="partial_type" value="metal" required>
                                                        <label for="partial_metal" class="option-card">
                                                            <div class="option-info">
                                                                <small>Metal</small>
                                                                <div class="option-title">فلزی</div>
                                                                <div class="option-description">پروتز پارسیل با پایه فلزی</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Acrylic Partial Type (Field 13) - Show when option 13 is selected -->
                                            <div class="service-field" id="field_13" style="display: none;">
                                                <div class="field-title">پروتز متحرک پارسیل آکریلی</div>
                                                <div class="field-subtitle">Acrylic Partial Removable Prosthesis</div>
                                                <div class="field-options">
                                                    <div class="field-option">
                                                        <input type="radio" id="acrylic_hard" name="acrylic_type" value="hard" required>
                                                        <label for="acrylic_hard" class="option-card">
                                                            <div class="option-info">
                                                                <small>Hard</small>
                                                                <div class="option-title">سخت</div>
                                                                <div class="option-description">پروتز آکریلی سخت و محکم</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="radio" id="acrylic_soft" name="acrylic_type" value="soft" required>
                                                        <label for="acrylic_soft" class="option-card">
                                                            <div class="option-info">
                                                                <small>Soft</small>
                                                                <div class="option-title">نرم</div>
                                                                <div class="option-description">پروتز آکریلی نرم و راحت</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Removable Services (Field 14) - Checkbox field - Show when option 3 is selected -->
                                            <div class="service-field" id="field_14" style="display: none;">
                                                <div class="field-title">خدمات پروتز متحرک</div>
                                                <div class="field-subtitle">Removable Prosthesis Services</div>
                                                <div class="field-options checkbox-options">
                                                    <div class="field-option">
                                                        <input type="checkbox" id="service_bar" name="removable_services[]" value="bar">
                                                        <label for="service_bar" class="option-card">
                                                            <div class="option-info">
                                                                <small>Bar</small>
                                                                <div class="option-title">بار</div>
                                                                <div class="option-description">اتصال‌دهنده فلزی بین ایمپلنت‌ها</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="checkbox" id="service_wing" name="removable_services[]" value="wing">
                                                        <label for="service_wing" class="option-card">
                                                            <div class="option-info">
                                                                <small>Wing</small>
                                                                <div class="option-title">بال</div>
                                                                <div class="option-description">بخش نگهدارنده پروتز روی دندان‌های طبیعی</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    
                                                    <div class="field-option">
                                                        <input type="checkbox" id="service_night_guard" name="removable_services[]" value="night_guard">
                                                        <label for="service_night_guard" class="option-card">
                                                            <div class="option-info">
                                                                <small>Night Guard</small>
                                                                <div class="option-title">نایت گارد</div>
                                                                <div class="option-description">محافظ شبانه برای جلوگیری از سایش دندان‌ها</div>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Step 3: Order Details -->
                                <div class="form-step" data-step="3">
                                    <div class="step-content">
                                        
                                        <!-- Patient Information Section -->
                                        <div class="form-section">
                                            <div class="section-title">اطلاعات بیمار</div>
                                            <p class="section-description">اطلاعات شخصی بیمار را وارد کنید.</p>
                                            
                                            <div class="form-fields">
                                                <div class="form-row">
                                                    <!-- Patient Name Field -->
                                                    <div class="form-field">
                                                        <label for="patient_name" class="field-label">
                                                            نام بیمار / مراجعه کننده <span class="required">*</span>
                                                        </label>
                                                        <input type="text" id="patient_name" name="patient_name" class="form-input" placeholder="نام و نام خانوادگی" required>
                                                        <div class="field-error" id="patient_name_error"></div>
                                                        <div class="field-help">نام کامل بیمار / مراجعه کننده را به صورت فارسی و کامل وارد نمایید</div>
                                                    </div>
                                                    
                                                    <!-- Patient Age Field -->
                                                    <div class="form-field">
                                                        <label for="patient_age" class="field-label">
                                                            سن بیمار
                                                        </label>
                                                        <div class="age-radio-group">
                                                            <div class="age-option">
                                                                <input type="radio" id="age_child" name="patient_age" value="child">
                                                                <label for="age_child" class="age-radio-label">
                                                                    <span class="age-text">کودک</span>
                                                                    <small class="age-description">زیر ۱۲ سال</small>
                                                                </label>
                                                            </div>
                                                            <div class="age-option">
                                                                <input type="radio" id="age_teen" name="patient_age" value="teen">
                                                                <label for="age_teen" class="age-radio-label">
                                                                    <span class="age-text">نوجوان</span>
                                                                    <small class="age-description">۱۲ تا ۱۸ سال</small>
                                                                </label>
                                                            </div>
                                                            <div class="age-option">
                                                                <input type="radio" id="age_adult" name="patient_age" value="adult">
                                                                <label for="age_adult" class="age-radio-label">
                                                                    <span class="age-text">بزرگسال</span>
                                                                    <small class="age-description">۱۹ سال و بالاتر</small>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Order Instructions Section -->
                                        <div class="form-section">
                                            <div class="section-title">دستور کار</div>
                                            <p class="section-description">هر چه توضیحات بیشتر و واضح‌تر باشد، نتیجه بهتری خواهیم داشت.</p>
                                            
                                            <div class="form-fields">
                                                <div class="form-field order-instructions-field">
                                                    <label for="order_note" class="field-label">
                                                        توضیحات دستور کار
                                                    </label>
                                                    <textarea id="order_note" name="order_note" class="form-textarea" rows="6" maxlength="500" placeholder="توضیحات خود را اینجا وارد کنید..."></textarea>
                                                    <div class="char-counter" id="char_counter" style="display: none;">
                                                        <span id="char_count">0</span> / 500
                                                    </div>
                                                    <div class="field-help">می‌توانید جزئیات بیشتری درباره سفارش خود اضافه کنید.</div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Step 4: Files -->
                                <div class="form-step" data-step="4">
                                    <div class="step-content">
                                        <div class="step-title">تصاویر و فایل ها</div>
                                        <p>فایل‌های مورد نیاز خود را آپلود کنید. حداکثر ۱۵ فایل با حجم هر فایل تا ۲۰۰ مگابایت.</P>
                                        
                                        <!-- File Upload Area -->
                                        <div class="dental-file-upload" id="dental-file-upload">
                                            <!-- Upload Area -->
                                            <div class="upload-area" id="dental-upload-area">
                                                <div class="upload-content">
                                                    <div class="upload-icon">
                                                        <i class="bi bi-cloud-upload"></i>
                                                    </div>
                                                    <h3 class="upload-title">فایل‌های خود را اینجا رها کنید</h3>
                                                    <p class="upload-description">
                                                        یا برای انتخاب فایل‌ها کلیک کنید
                                                    </p>
                                                    <button type="button" class="btn btn-primary upload-btn" id="dental-select-btn">
                                                        <i class="bi bi-folder2-open"></i>
                                                        انتخاب فایل‌ها
                                                    </button>
                                                    <input type="file" id="dental-file-input" multiple accept=".png,.jpg,.jpeg,.webp,.heic,.heif,.mp4,.webm,.mov,.avi,.mkv,.mp3,.wav,.ogg,.m4a,.aac,.flac,.zip,.rar,.7z,.tar,.gz,.stl,.fly,.pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.csv,.txt,.rtf" style="display: none;">
                                                </div>
                                                
                                                <!-- Upload Progress Container -->
                                                <div class="upload-progress-container" id="dental-progress" style="display: none;">
                                                    <div class="upload-progress-header">
                                                        <h4>در حال آپلود فایل‌ها...</h4>
                                                        <button type="button" class="btn-cancel-upload" id="dental-cancel-btn">
                                                            <i class="bi bi-x-circle"></i>
                                                            لغو
                                                        </button>
                                                    </div>
                                                    <div class="upload-progress-list" id="dental-progress-list">
                                                        <!-- Progress items will be added here dynamically -->
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <!-- File List -->
                                            <div class="file-list-container" id="dental-file-list" style="display: none;">
                                                <div class="file-list-header">
                                                    <h4>فایل‌های انتخاب شده</h4>
                                                    <div class="file-list-actions">
                                                        <span class="file-count" id="dental-file-count">0 فایل</span>
                                                        <button type="button" class="btn-clear-all" id="dental-clear-btn">
                                                            <i class="bi bi-trash"></i>
                                                            حذف همه
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="file-list" id="dental-file-list-items">
                                                    <!-- File items will be added here dynamically -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Navigation Buttons -->
                            <div class="form-navigation">
                                <button type="button" class="btn btn-secondary" id="prev_step" style="display: none;">
                                    <i class="bi bi-arrow-right"></i>
                                    <span id="prev_step_text">مرحله قبل</span>
                                </button>
                                <button type="button" class="btn btn-primary" id="next_step">
                                    <span id="next_step_text">انتخاب زیر خدمات</span>
                                    <i class="bi bi-arrow-left"></i>
                                </button>
                                <input type="submit" class="btn btn-primary" id="submit_order" value="ثبت سفارش" style="display: none;">
                            </div>
                        </form>
                        
                        <!-- Order Summary Overlay -->
                        <div class="order-summary-overlay" id="order-summary-overlay" style="display: none;">
                            <div class="summary-overlay-content">
                                <div class="summary-header">
                                    <h2 class="summary-title">
                                        <i class="bi bi-clipboard-check"></i>
                                        بررسی نهایی سفارش
                                    </h2>
                                    <p class="summary-subtitle">لطفاً اطلاعات زیر را بررسی کنید و در صورت صحت، سفارش را ثبت کنید.</p>
                                </div>
                                
                                <div class="summary-body">
                                    <!-- Step 1 Summary -->
                                    <div class="summary-section">
                                        <div class="summary-section-header">
                                            <div class="summary-section-number">1</div>
                                            <h3 class="summary-section-title">خدمات انتخاب شده</h3>
                                        </div>
                                        <div class="summary-section-content" id="summary-step-1">
                                            <!-- Will be populated by JS -->
                                        </div>
                                    </div>
                                    
                                    <!-- Step 2 Summary -->
                                    <div class="summary-section">
                                        <div class="summary-section-header">
                                            <div class="summary-section-number">2</div>
                                            <h3 class="summary-section-title">زیر خدمات انتخاب شده</h3>
                                        </div>
                                        <div class="summary-section-content" id="summary-step-2">
                                            <!-- Will be populated by JS -->
                                        </div>
                                    </div>
                                    
                                    <!-- Step 3 Summary -->
                                    <div class="summary-section">
                                        <div class="summary-section-header">
                                            <div class="summary-section-number">3</div>
                                            <h3 class="summary-section-title">اطلاعات بیمار و دستور کار</h3>
                                        </div>
                                        <div class="summary-section-content" id="summary-step-3">
                                            <!-- Will be populated by JS -->
                                        </div>
                                    </div>
                                    
                                    <!-- Step 4 Summary -->
                                    <div class="summary-section">
                                        <div class="summary-section-header">
                                            <div class="summary-section-number">4</div>
                                            <h3 class="summary-section-title">فایل‌های آپلود شده</h3>
                                        </div>
                                        <div class="summary-section-content" id="summary-step-4">
                                            <!-- Will be populated by JS -->
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="summary-footer">
                                    <button type="button" class="btn btn-secondary" id="summary-cancel-btn">
                                        <i class="bi bi-arrow-right"></i>
                                        بازگشت و ویرایش
                                    </button>
                                    <button type="button" class="btn btn-primary" id="summary-submit-btn">
                                        <i class="bi bi-check-circle"></i>
                                        ثبت نهایی سفارش
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Orders Section -->
            <div id="orders-section" class="content-section">
                <div class="section-title-bar">
                    <h1><?php _e('سفارشات', 'etiuse-lab'); ?></h1>
                    <p><?php _e('مشاهده و مدیریت تمام سفارشات شما - فیلتر، جستجو و پیگیری وضعیت سفارشات', 'etiuse-lab'); ?></p>
                </div>
                <div class="content-card full-width">
                    <div class="card-body">
                        <!-- Filter Section -->
                        <div class="orders-filter-section">
                            <div class="filter-header">
                                <button type="button" class="filter-toggle-btn" id="filter-toggle">
                                    <i class="bi bi-funnel"></i>
                                    <span class="filter-text">نمایش فیلتر</span>
                                    <i class="bi bi-chevron-down filter-arrow"></i>
                                </button>
                                
                                <button type="button" class="btn btn-outline-secondary btn-sm clear-filters-btn" id="clear-filters" style="display: none;">
                                    <i class="bi bi-x"></i>
                                    پاک کردن فیلترها
                                </button>
                            </div>
                            
                            <div class="filter-content" id="filter-content">
                                <div class="filter-grid">
                                    <!-- Search Filter -->
                                    <div class="filter-column">
                                        <label class="filter-label">جستجو</label>
                                        <div class="search-filter">
                                            <input type="text" id="search-filter" class="form-control" placeholder="نام مراجعه کننده / کد سفارش ..." minlength="3">
                                            <div class="search-spinner" style="display: none;">
                                                <i class="bi bi-arrow-clockwise"></i>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Service Type Filter -->
                                    <div class="filter-column">
                                        <label class="filter-label">نوع خدمات</label>
                                        <div class="service-type-filter">
                                            <select id="service-type-filter" class="form-control">
                                                <option value="">همه انواع خدمات</option>
                                                <option value="orthodontics">ارتودنسی</option>
                                                <option value="fixed_prosthesis">پروتز ثابت</option>
                                                <option value="removable_prosthesis">پروتز متحرک</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <!-- Date Filter -->
                                    <!-- <div class="filter-column">
                                        <label class="filter-label">تاریخ</label>
                                        <div class="date-filter">
                                            <input type="text" class="date-input" id="date-range-input" placeholder="انتخاب بازه زمانی" />
                                        </div>
                                    </div> -->
                                    
                                    <!-- Status Filter -->
                                    <div class="filter-column">
                                        <label class="filter-label">وضعیت</label>
                                        <div class="status-filter">
                                            <select id="status-filter" class="form-control">
                                                <option value="">همه وضعیت‌ها</option>
                                                <option value="pending">در انتظار</option>
                                                <option value="in_progress">در حال انجام</option>
                                                <option value="completed">تکمیل شده</option>
                                                <option value="cancelled">لغو شده</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        

                        
                        <!-- Active Filters Display -->
                        <div class="active-filters" id="active-filters" style="display: none;">
                            <div class="active-filters-header">
                                <span class="active-filters-title">فیلترهای فعال:</span>
                            </div>
                            <div class="active-filters-list" id="active-filters-list">
                                <!-- Active filters will be displayed here -->
                            </div>
                        </div>
                        
                        <div class="orders-table-container">
                            <table class="orders-table" id="orders-table">
                                <thead class="orders-table-header">
                                    <tr>
                                        <th class="order-id sortable" data-sort="dental_id">
                                            <?php _e('شماره سفارش', 'etiuse-lab'); ?>
                                            <i class="sort-icon fi-tr-sort-alt"></i>
                                        </th>
                                        <th class="order-patient"><?php _e('مراجعه کننده', 'etiuse-lab'); ?></th>
                                        <th class="order-service sortable" data-sort="service_type">
                                            <?php _e('نوع خدمات', 'etiuse-lab'); ?>
                                            <i class="sort-icon fi-tr-sort-alt"></i>
                                        </th>
                                        <th class="order-date sortable" data-sort="created_at">
                                            <?php _e('تاریخ', 'etiuse-lab'); ?>
                                            <i class="sort-icon fi-tr-sort-alt"></i>
                                        </th>
                                        <th class="order-status"><?php _e('وضعیت', 'etiuse-lab'); ?></th>
                                    </tr>
                                </thead>
                                <tbody class="orders-table-body" id="orders-table-body">
                                    <!-- Orders will be loaded here dynamically -->
                                </tbody>
                            </table>
                            
                            <!-- Loading State -->
                            <div class="orders-loading" id="orders-loading">
                                <div class="loading-spinner">
                                    <i class="bi bi-arrow-clockwise"></i>
                                </div>
                                <p><?php _e('در حال بارگذاری سفارشات...', 'etiuse-lab'); ?></p>
                            </div>
                            
                            <!-- Empty State -->
                            <div class="orders-empty" id="orders-empty" style="display: none;">
                            <i class="bi bi-list-ul"></i>
                                <p><?php _e('هیچ سفارشی یافت نشد.', 'etiuse-lab'); ?></p>
                                <a href="#new-order" class="btn btn-primary">
                                    <?php _e('سفارش جدید', 'etiuse-lab'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Charges Section -->
            <div id="charges-section" class="content-section">
                <div class="section-title-bar">
                    <h1><?php _e('شارژ حساب', 'etiuse-lab'); ?></h1>
                    <p><?php _e('مدیریت موجودی حساب و شارژ اعتبار - مشاهده تراکنش‌ها و پرداخت‌های آنلاین', 'etiuse-lab'); ?></p>
                </div>
                <div class="content-card full-width">
                    <div class="card-body">
                        <div class="empty-state">
                            <i class="bi bi-credit-card"></i>
                            <p><?php _e('صفحه شارژ حساب در حال آماده‌سازی است...', 'etiuse-lab'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>

<?php get_footer(); ?>
