<?php
/**
 * Generic Dashboard Template
 * 
 * This template serves as a fallback for all dashboard routes
 */

get_header(); 

$current_user = wp_get_current_user();
$user_role = etiuse_get_current_user_role();
$role_display_name = etiuse_get_role_display_name($user_role);
?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar">
            <div class="position-sticky pt-3">
                <div class="text-center mb-4">
                    <div class="avatar-placeholder bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                        <span class="fs-4"><?php echo strtoupper(substr($current_user->display_name, 0, 1)); ?></span>
                    </div>
                    <h6 class="mt-2 mb-1"><?php echo esc_html($current_user->display_name); ?></h6>
                    <small class="text-muted"><?php echo esc_html($role_display_name); ?></small>
                </div>
                
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link active" href="<?php echo etiuse_get_user_dashboard_url(); ?>">
                            <i class="bi bi-house-door"></i>
                            <?php _e('داشبورد', 'etiuse-lab'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo home_url(); ?>">
                            <i class="bi bi-arrow-left"></i>
                            <?php _e('بازگشت به سایت', 'etiuse-lab'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo wp_logout_url(home_url()); ?>">
                            <i class="bi bi-box-arrow-right"></i>
                            <?php _e('خروج', 'etiuse-lab'); ?>
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Main content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php _e('داشبورد', 'etiuse-lab'); ?></h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <span class="badge bg-primary"><?php echo esc_html($role_display_name); ?></span>
                    </div>
                </div>
            </div>

            <!-- Welcome Section -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?php _e('خوش آمدید', 'etiuse-lab'); ?></h5>
                            <p class="card-text">
                                <?php printf(__('سلام %s، به داشبورد %s خوش آمدید.', 'etiuse-lab'), 
                                    esc_html($current_user->display_name), 
                                    esc_html($role_display_name)
                                ); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Dashboard Content -->
            <div class="row mt-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?php _e('اطلاعات کاربری', 'etiuse-lab'); ?></h5>
                            <ul class="list-unstyled">
                                <li><strong><?php _e('نام:', 'etiuse-lab'); ?></strong> <?php echo esc_html($current_user->display_name); ?></li>
                                <li><strong><?php _e('ایمیل:', 'etiuse-lab'); ?></strong> <?php echo esc_html($current_user->user_email); ?></li>
                                <li><strong><?php _e('نقش:', 'etiuse-lab'); ?></strong> <?php echo esc_html($role_display_name); ?></li>
                                <li><strong><?php _e('تاریخ عضویت:', 'etiuse-lab'); ?></strong> <?php echo date_i18n(get_option('date_format'), strtotime($current_user->user_registered)); ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?php _e('دسترسی‌های شما', 'etiuse-lab'); ?></h5>
                            <p class="card-text">
                                <?php _e('شما به عنوان', 'etiuse-lab'); ?> <strong><?php echo esc_html($role_display_name); ?></strong> 
                                <?php _e('به بخش‌های مربوط به نقش خود دسترسی دارید.', 'etiuse-lab'); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Role-specific content can be added here -->
            <?php do_action('etiuse_dashboard_content_' . $user_role); ?>
        </main>
    </div>
</div>

<style>
.sidebar {
    min-height: 100vh;
    box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
}

.avatar-placeholder {
    font-weight: bold;
}

@media (max-width: 767.98px) {
    .sidebar {
        position: static;
        height: auto;
        padding-top: 0;
    }
}
</style>

<?php get_footer(); ?>
