<?php
/**
 * Single Dental Order Template
 * 
 * Displays a single dental order details page
 * URL: /d/{dental_id}
 */

get_header();

// Get dental order ID from query var
$dental_order_id = get_query_var('dental_order_id');

// Enqueue styles if needed
wp_enqueue_style('dashboard-styles', get_template_directory_uri() . '/css/dashboard.css', array(), '1.0.0');

$current_user = wp_get_current_user();
$user_role = etiuse_get_current_user_role();
$role_display_name = etiuse_get_role_display_name($user_role);
?>

<div class="dashboard-container">
    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebar-overlay"></div>
    
    <!-- Fixed Right Sidebar -->
    <aside class="dashboard-sidebar" id="dashboard-sidebar">
        <!-- Logo Section -->
        <div class="sidebar-logo">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/brand/logo-dark.png" alt="Logo" class="logo-image">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/brand/icon.png" alt="Icon" class="logo-icon">
        </div>
        
        <!-- Navigation Menu Section -->
        <nav class="sidebar-nav">
            <ul class="nav-menu">
                <li class="nav-item">
                    <a href="<?php echo etiuse_get_user_dashboard_url(); ?>" class="nav-link">
                        <i class="bi bi-house-door"></i>
                        <span class="nav-text"><?php _e('داشبورد', 'etiuse-lab'); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo etiuse_get_user_dashboard_url(); ?>#new-order" class="nav-link">
                        <i class="bi bi-plus-circle"></i>
                        <span class="nav-text"><?php _e('سفارش جدید', 'etiuse-lab'); ?></span>
                    </a>
                </li>
                <li class="nav-item">
                    <a href="<?php echo etiuse_get_user_dashboard_url(); ?>#orders" class="nav-link">
                        <i class="bi bi-list-ul"></i>
                        <span class="nav-text"><?php _e('سفارشات', 'etiuse-lab'); ?></span>
                    </a>
                </li>
            </ul>
        </nav>
        
        <!-- User Account Section (Fixed at bottom) -->
        <div class="sidebar-account">
            <div class="user-profile">
                <div class="user-avatar">
                    <i class="bi bi-person"></i>
                </div>
                <div class="user-info">
                    <?php 
                    $first_name = get_user_meta($current_user->ID, 'first_name', true);
                    $last_name = get_user_meta($current_user->ID, 'last_name', true);
                    $full_name = trim($first_name . ' ' . $last_name);
                    if (empty($full_name)) {
                        $full_name = $current_user->display_name;
                    }
                    ?>
                    <div class="user-name"><?php echo esc_html($full_name); ?></div>
                    <?php 
                    $user_type = get_user_meta($current_user->ID, 'user_type', true);
                    if ($user_type): 
                        $user_type_labels = array(
                            'Clinic' => 'مطب',
                            'Lab' => 'لابراتوار'
                        );
                        $user_type_label = isset($user_type_labels[$user_type]) ? $user_type_labels[$user_type] : $user_type;
                    ?>
                        <div class="user-type"><?php echo esc_html($user_type_label); ?></div>
                    <?php endif; ?>
                </div>
                <div class="user-settings">
                    <button class="settings-toggle" id="settings-toggle">
                        <i class="bi bi-gear"></i>
                    </button>
                    <div class="settings-dropdown" id="settings-dropdown">
                        <a href="<?php echo home_url('/p/account'); ?>" class="dropdown-item">
                            <i class="bi bi-person-circle"></i>
                            <span><?php _e('حساب کاربری', 'etiuse-lab'); ?></span>
                        </a>
                        <a href="<?php echo wp_logout_url(home_url()); ?>" class="dropdown-item logout">
                            <i class="bi bi-box-arrow-right"></i>
                            <span><?php _e('خروج از حساب کاربری', 'etiuse-lab'); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </aside>

    <!-- Main Content Area -->
    <main class="dashboard-main">
        <!-- Sticky Header -->
        <header class="dashboard-header">
            <div class="header-content">
                <div class="header-left">
                    <button class="sidebar-toggle" id="sidebar-toggle">
                        <i class="bi bi-list"></i>
                    </button>
                </div>
                <div class="header-right">
                    <div class="header-actions">
                        <div class="header-icon support" title="<?php _e('پشتیبانی', 'etiuse-lab'); ?>">
                            <i class="bi bi-headset"></i>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <div class="dashboard-content">
            <!-- Single Order Section -->
            <div class="content-section active">
                <div class="section-title-bar">
                    <h1><?php _e('جزئیات سفارش', 'etiuse-lab'); ?></h1>
                    <p><?php _e('شماره سفارش: ', 'etiuse-lab'); ?><?php echo esc_html($dental_order_id); ?></p>
                </div>
                
                <div class="content-card full-width">
                    <div class="card-body">
                        <!-- Order content will be added here -->
                        <p><?php _e('محتوای صفحه سفارش در حال آماده‌سازی است...', 'etiuse-lab'); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </main>
</div>

<?php get_footer(); ?>

