<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function add_dental_orders_menu() {
    add_menu_page(
        'Dental Orders',        // Page Title
        'Dental Orders',        // Menu Title
        'manage_options',       // Capability (Only admins can access)
        'dental-orders',        // Menu Slug
        'dental_orders_page',   // Function to Display Content
        'dashicons-list-view',  // Icon
        20                     // Position (After Posts, Before Appearance)
    );
}
add_action('admin_menu', 'add_dental_orders_menu'); // Hook into Admin Menu

function dental_orders_page() {
    echo '<div class="wrap"><h1>Dental Orders</h1><p>This is a blank page for now.</p></div>';
}

function etiuse_register_settings_page() {
    add_menu_page(
        'Etiuse Settings', 
        'Etiuse Settings', 
        'manage_options', 
        'etiuse-settings', 
        'etiuse_settings_page_content',
        'dashicons-admin-generic',
        90
    );
}
add_action('admin_menu', 'etiuse_register_settings_page');

function etiuse_settings_page_content() {
    $settings_fields = [
        'lab_phone' => 'Lab Phone',
        'lab_phone_link' => 'Lab Phone Link',
        'lab_email' => 'Lab Email',
        'lab_email_link' => 'Lab Email Link',
        'landline_phone' => 'Landline Phone',
        'landline_phone_link' => 'Landline Phone Link',
        'accountant_phone' => 'Accountant Phone',
        'accountant_phone_link' => 'Accountant Phone Link',
        'support_phone' => 'Support Phone',
        'support_phone_link' => 'Support Phone Link',
        'support_email' => 'Support Email',
        'support_email_link' => 'Support Email Link',
        'recaptcha_site_key' => 'ReCAPTCHA Site Key',
        'recaptcha_secret_key' => 'ReCAPTCHA Secret Key',
    ];

    if (isset($_POST['etiuse_save_settings']) && check_admin_referer('etiuse_settings_action', 'etiuse_settings_nonce')) {
        $new_settings = [];
        foreach ($settings_fields as $key => $label) {
            $new_settings[$key] = sanitize_text_field($_POST[$key]);
        }
        update_option('etiuse_settings', $new_settings);
        echo '<div class="updated"><p>Settings saved.</p></div>';
    }
    $settings = get_option('etiuse_settings', []);
    ?>
    <div class="wrap">
        <h1>Etiuse Settings</h1>
        <form method="post">
            <?php wp_nonce_field('etiuse_settings_action', 'etiuse_settings_nonce'); ?>
            <table class="form-table" style="width: 100%; border-collapse: collapse;">
                <tr>
                    <td colspan="2">
                        <p>Click on the field labels to copy the meta-field key.</p>
                    </td>
                </tr>
                <?php $counter = 0; ?>
                <?php foreach ($settings_fields as $key => $label) : ?>
                    <?php if ($counter % 2 == 0) echo '<tr style="border-bottom: 1px solid #ccc;">'; ?>
                    <td style="width: 50%; padding: 10px; vertical-align: top;">
                        <label for="<?php echo $key; ?>" style="font-weight: bold; display: block;"> <?php echo $label; ?> </label>
                        <input type="text" id="<?php echo $key; ?>" name="<?php echo $key; ?>" value="<?php echo isset($settings[$key]) ? esc_attr($settings[$key]) : ''; ?>" class="regular-text" style="width: 100%;">
                        <label class="copy-key" data-key="etiuse_settings[<?php echo $key; ?>]" style="background: #f5f5f5; padding: 5px; display: block; text-align: left; cursor: pointer; margin-top: 5px;">[<?php echo $key; ?>]</label>
                    </td>
                    <?php if ($counter % 2 == 1) echo '</tr>'; ?>
                    <?php $counter++; ?>
                <?php endforeach; ?>
                <?php if ($counter % 2 == 1) echo '<td style="width: 50%;"></td></tr>'; ?>
            </table>
            <p><input type="submit" name="etiuse_save_settings" class="button-primary" value="Save Settings"></p>
        </form>
    </div>
    <script>
    document.querySelectorAll('.copy-key').forEach(label => {
        label.addEventListener('click', function() {
            navigator.clipboard.writeText(this.dataset.key);
        });
    });
    </script>
    <?php
}