<?php
/**
 * Access Denied Template
 * 
 * This template is displayed when:
 * - User is not logged in
 * - User doesn't have permission to access the requested dashboard
 */

get_header(); ?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6">
            <div class="card shadow-sm border-0">
                <div class="card-body text-center p-5">
                    <div class="mb-4">
                        <svg width="64" height="64" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 2C13.1 2 14 2.9 14 4C14 5.1 13.1 6 12 6C10.9 6 10 5.1 10 4C10 2.9 10.9 2 12 2ZM21 9V7L15 1H5C3.89 1 3 1.89 3 3V21C3 22.11 3.89 23 5 23H19C20.11 23 21 22.11 21 21V9ZM19 9H14V4H5V21H19V9Z" fill="#dc3545"/>
                        </svg>
                    </div>
                    
                    <h2 class="card-title mb-3 text-danger"><?php _e('دسترسی محدود', 'etiuse-lab'); ?></h2>
                    
                    <p class="card-text text-muted mb-4">
                        <?php if (!is_user_logged_in()): ?>
                            <?php _e('برای دسترسی به این صفحه، لطفا ابتدا وارد حساب کاربری خود شوید.', 'etiuse-lab'); ?>
                        <?php else: ?>
                            <?php _e('متأسفانه شما مجوز دسترسی به این صفحه را ندارید.', 'etiuse-lab'); ?>
                        <?php endif; ?>
                    </p>
                    
                    <div class="d-grid gap-2">
                        <?php if (!is_user_logged_in()): ?>
                            <a href="<?php echo home_url('/login'); ?>" class="btn btn-primary">
                                <?php _e('ورود به سیستم', 'etiuse-lab'); ?>
                            </a>
                        <?php else: ?>
                            <a href="<?php echo etiuse_get_user_dashboard_url(); ?>" class="btn btn-primary">
                                <?php _e('رفتن به داشبورد', 'etiuse-lab'); ?>
                            </a>
                        <?php endif; ?>
                        
                        <a href="<?php echo home_url(); ?>" class="btn btn-outline-secondary">
                            <?php _e('بازگشت به صفحه اصلی', 'etiuse-lab'); ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>
