<?php
/**
 * Manager Dashboard Template
 * 
 * Specific dashboard for users with 'manager' role
 */

get_header(); 

$current_user = wp_get_current_user();
$user_role = etiuse_get_current_user_role();
$role_display_name = etiuse_get_role_display_name($user_role);
?>

<div class="container-fluid">
    <div class="row">
        <!-- Sidebar -->
        <nav class="col-md-3 col-lg-2 d-md-block bg-light sidebar">
            <div class="position-sticky pt-3">
                <div class="text-center mb-4">
                    <div class="avatar-placeholder bg-primary text-white rounded-circle d-inline-flex align-items-center justify-content-center" style="width: 60px; height: 60px;">
                        <span class="fs-4"><?php echo strtoupper(substr($current_user->display_name, 0, 1)); ?></span>
                    </div>
                    <h6 class="mt-2 mb-1"><?php echo esc_html($current_user->display_name); ?></h6>
                    <small class="text-muted"><?php echo esc_html($role_display_name); ?></small>
                </div>
                
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link active" href="<?php echo home_url('/p/m'); ?>">
                            <i class="bi bi-house-door"></i>
                            <?php _e('داشبورد', 'etiuse-lab'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#users">
                            <i class="bi bi-people"></i>
                            <?php _e('مدیریت کاربران', 'etiuse-lab'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#reports">
                            <i class="bi bi-graph-up"></i>
                            <?php _e('گزارشات', 'etiuse-lab'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#settings">
                            <i class="bi bi-gear"></i>
                            <?php _e('تنظیمات', 'etiuse-lab'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo home_url(); ?>">
                            <i class="bi bi-arrow-left"></i>
                            <?php _e('بازگشت به سایت', 'etiuse-lab'); ?>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo wp_logout_url(home_url()); ?>">
                            <i class="bi bi-box-arrow-right"></i>
                            <?php _e('خروج', 'etiuse-lab'); ?>
                        </a>
                    </li>
                </ul>
            </div>
        </nav>

        <!-- Main content -->
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2"><?php _e('داشبورد مدیر', 'etiuse-lab'); ?></h1>
                <div class="btn-toolbar mb-2 mb-md-0">
                    <div class="btn-group me-2">
                        <span class="badge bg-primary"><?php echo esc_html($role_display_name); ?></span>
                    </div>
                </div>
            </div>

            <!-- Welcome Section -->
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <h5 class="card-title"><?php _e('خوش آمدید مدیر محترم', 'etiuse-lab'); ?></h5>
                            <p class="card-text">
                                <?php printf(__('سلام %s، به داشبورد مدیریتی خوش آمدید. شما دسترسی کامل به تمام بخش‌های سیستم را دارید.', 'etiuse-lab'), 
                                    esc_html($current_user->display_name)
                                ); ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="row mt-4">
                <div class="col-md-3">
                    <div class="card text-white bg-primary">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title"><?php echo count_users()['total_users']; ?></h4>
                                    <p class="card-text"><?php _e('کل کاربران', 'etiuse-lab'); ?></p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-people fs-1"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="card text-white bg-success">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title"><?php echo count_users()['avail_roles']['client'] ?? 0; ?></h4>
                                    <p class="card-text"><?php _e('مشتریان', 'etiuse-lab'); ?></p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-person-check fs-1"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="card text-white bg-warning">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title"><?php echo count_users()['avail_roles']['specialist'] ?? 0; ?></h4>
                                    <p class="card-text"><?php _e('متخصصین', 'etiuse-lab'); ?></p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-person-badge fs-1"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="card text-white bg-info">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="card-title"><?php echo count_users()['avail_roles']['lab'] ?? 0; ?></h4>
                                    <p class="card-text"><?php _e('آزمایشگاه‌ها', 'etiuse-lab'); ?></p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-building fs-1"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Manager Actions -->
            <div class="row mt-4">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0"><?php _e('عملیات سریع', 'etiuse-lab'); ?></h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="#add-user" class="btn btn-primary">
                                    <i class="bi bi-person-plus"></i>
                                    <?php _e('افزودن کاربر جدید', 'etiuse-lab'); ?>
                                </a>
                                <a href="#manage-roles" class="btn btn-secondary">
                                    <i class="bi bi-shield-check"></i>
                                    <?php _e('مدیریت نقش‌ها', 'etiuse-lab'); ?>
                                </a>
                                <a href="#system-settings" class="btn btn-info">
                                    <i class="bi bi-gear"></i>
                                    <?php _e('تنظیمات سیستم', 'etiuse-lab'); ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0"><?php _e('گزارشات اخیر', 'etiuse-lab'); ?></h5>
                        </div>
                        <div class="card-body">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php _e('کاربران جدید امروز', 'etiuse-lab'); ?>
                                    <span class="badge bg-primary rounded-pill">0</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php _e('درخواست‌های در انتظار', 'etiuse-lab'); ?>
                                    <span class="badge bg-warning rounded-pill">0</span>
                                </li>
                                <li class="list-group-item d-flex justify-content-between align-items-center">
                                    <?php _e('گزارشات سیستمی', 'etiuse-lab'); ?>
                                    <span class="badge bg-success rounded-pill">0</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="row mt-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0"><?php _e('فعالیت‌های اخیر', 'etiuse-lab'); ?></h5>
                        </div>
                        <div class="card-body">
                            <p class="text-muted"><?php _e('هیچ فعالیتی برای نمایش وجود ندارد.', 'etiuse-lab'); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>



<style>
.sidebar {
    min-height: 100vh;
    box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
}

.avatar-placeholder {
    font-weight: bold;
}

@media (max-width: 767.98px) {
    .sidebar {
        position: static;
        height: auto;
        padding-top: 0;
    }
}
</style>

<?php get_footer(); ?>
