<?php
/**
 * Sign-up Template for Subscriber Role
 * 
 * Multi-step form for collecting user information
 */

get_header();

// Enqueue styles and scripts
wp_enqueue_style('dashboard-styles', get_template_directory_uri() . '/css/dashboard.css', array(), '1.0.0');
wp_enqueue_style('signup-styles', get_template_directory_uri() . '/css/signup.css', array(), '1.0.0');

// Add Neshan Leaflet Web SDK
wp_enqueue_style('neshan-leaflet-css', 'https://static.neshan.org/sdk/leaflet/v1.9.4/neshan-sdk/v1.0.8/index.css', array(), '1.0.8');
wp_enqueue_script('neshan-leaflet-js', 'https://static.neshan.org/sdk/leaflet/v1.9.4/neshan-sdk/v1.0.8/index.js', array(), '1.0.8', true);
wp_enqueue_script('signup-scripts', get_template_directory_uri() . '/js/signup.js', array('jquery', 'neshan-leaflet-js'), '1.0.0', true);

// Localize script
wp_localize_script('signup-scripts', 'signupLocalization', array(
    'ajaxUrl' => admin_url('admin-ajax.php'),
    'userId' => get_current_user_id(),
    'nonces' => array(
        'save_user_type' => wp_create_nonce('save_user_type'),
        'save_user_info' => wp_create_nonce('save_user_info'),
        'save_user_address' => wp_create_nonce('save_user_address')
    )
));

$current_user = wp_get_current_user();
$user_type = get_user_meta($current_user->ID, 'user_type', true);
$user_organization = get_user_meta($current_user->ID, 'user_organization_name', true);

// Get address data as array
$user_address_data = get_user_meta($current_user->ID, 'user_address', true);
if (is_string($user_address_data)) {
    $user_address_data = json_decode($user_address_data, true);
}
if (!is_array($user_address_data)) {
    $user_address_data = [
        'geo_coordinates' => '',
        'address' => '',
        'address_details' => '',
        'address_notes' => '',
        'address_phone' => ''
    ];
}

// For backward compatibility, extract individual values
$user_address = $user_address_data['address'] ?? '';
$user_geo_location = $user_address_data['geo_coordinates'] ?? '';

// Determine current step based on existing data
$current_step = 1;

// Check if user type is set
if ($user_type) {
    $current_step = 2;
    
    // Check if personal info is complete
    if ($current_user->first_name && $current_user->last_name) {
        // If lab user, also check organization name
        if ($user_type === 'Lab' && $user_organization) {
            $current_step = 3;
        } elseif ($user_type === 'Clinic') {
            $current_step = 3;
        }
        
        // Check if address is set
        if ($user_address_data['address']) {
            $current_step = 4; // All steps completed
        }
    }
}
?>

<div class="signup-container">
    <!-- Header -->
    <div class="signup-header">
        <div class="signup-logo">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/brand/logo-dark.png" alt="Logo" class="logo-image">
        </div>
        <div class="signup-title">
            <h1><?php _e('تکمیل اطلاعات کاربری', 'etiuse-lab'); ?></h1>
            <p><?php _e('لطفاً اطلاعات خود را تکمیل کنید تا بتوانیم بهتر به شما خدمات ارائه دهیم.', 'etiuse-lab'); ?></p>
        </div>
    </div>

    <!-- Form Container -->
    <div class="signup-form-container">
        <!-- Step Counter -->
        <div class="signup-step-counter" id="step-counter">
            <span class="step-counter-text">مرحله <?php echo $current_step; ?> از 3</span>
        </div>
        
        <form id="signup-form" class="signup-form">
            <input type="hidden" name="user_id" value="<?php echo get_current_user_id(); ?>">
            
            <!-- Step 1: User Type -->
            <div class="form-step <?php echo $current_step == 1 ? 'active' : ''; ?>" data-step="1">
                <div class="step-content">
                    <div class="step-title">انتخاب نوع کاربری</div>
                    <p class="step-description">انتخاب نوع کاربری به بهبود تجربه و خدمات شما کمک می‌کند.</p>
                    
                    <div class="radio-group">
                        <div class="radio-option">
                            <input type="radio" id="user_type_clinic" name="user_type" value="Clinic" <?php checked($user_type, 'Clinic'); ?>>
                            <label for="user_type_clinic" class="radio-label">
                                <div class="radio-info">
                                    <span class="radio-text">مطب دندانپزشکی</span>
                                    <small class="radio-description">مناسب دندانپزشک، دستیار دندانپزشک و مطب دندانپزشکی</small>
                                </div>
                            </label>
                        </div>
                        
                        <div class="radio-option">
                            <input type="radio" id="user_type_lab" name="user_type" value="Lab" <?php checked($user_type, 'Lab'); ?>>
                            <label for="user_type_lab" class="radio-label">
                                <div class="radio-info">
                                    <span class="radio-text">لابراتوار دندانسازی</span>
                                    <small class="radio-description">مناسب لابراتوار دندانسازی و تکنسین دندان‌سازی</small>
                                </div>
                            </label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 2: Personal Information -->
            <div class="form-step <?php echo $current_step == 2 ? 'active' : ''; ?>" data-step="2">
                <div class="step-content">
                    <div class="step-title">اطلاعات شخصی</div>
                    <p class="step-description">نام و نام خانوادگی خود را وارد کنید</p>
                    
                    <div class="form-fields">
                        <div class="form-row">
                            <div class="form-field">
                                <div class="floating-field">
                                    <input type="text" id="first_name" name="first_name" class="form-input" value="<?php echo esc_attr($current_user->first_name); ?>" data-required="true" autocomplete="given-name">
                                    <label for="first_name" class="floating-label">
                                        <span class="field-icon">
                                            <i class="bi bi-person"></i>
                                        </span>
                                        <span class="label-text">نام</span>
                                    </label>
                                </div>
                            </div>
                            
                            <div class="form-field">
                                <div class="floating-field">
                                    <input type="text" id="last_name" name="last_name" class="form-input" value="<?php echo esc_attr($current_user->last_name); ?>" data-required="true" autocomplete="family-name">
                                    <label for="last_name" class="floating-label">
                                        <span class="field-icon">
                                            <i class="bi bi-person"></i>
                                        </span>
                                        <span class="label-text">نام خانوادگی</span>
                                    </label>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Organization Name (only for lab users) -->
                        <div class="form-field organization-field" id="organization_field" style="display: none;">
                            <div class="floating-field">
                                <input type="text" id="organization_name" name="organization_name" class="form-input" value="<?php echo esc_attr($user_organization); ?>" data-required="true" autocomplete="organization">
                                <label for="organization_name" class="floating-label">
                                    <span class="field-icon">
                                        <i class="bi bi-building"></i>
                                    </span>
                                    <span class="label-text">نام لابراتوار</span>
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 3: Address -->
            <div class="form-step <?php echo $current_step == 3 ? 'active' : ''; ?>" data-step="3">
                <div class="step-content">
                    <div class="step-title">آدرس</div>
                    <p class="step-description">آدرس خود را وارد کنید</p>
                    
                    <div class="form-fields">
                        <!-- Geo Location -->
                        <div class="form-field">
                            <div class="geo-location-field">
                                <label class="geo-label">
                                    <span class="field-icon">
                                        <i class="bi bi-map"></i>
                                    </span>
                                    <span class="label-text">انتخاب موقعیت روی نقشه</span>
                                </label>
                                
                                <div id="location-map" class="location-map-container">
                                    <!-- Search Field on Map -->
                                    <div class="map-search-overlay">
                                        <div class="map-search-field">
                                            <i class="bi bi-search"></i>
                                            <input type="text" id="address-search" placeholder="جستجوی آدرس..." autocomplete="off">
                                        </div>
                                        <div id="search-results" class="search-results" style="display: none;"></div>
                                    </div>
                                    
                                    <!-- My Location Button -->
                                    <div class="my-location-overlay">
                                        <div class="my-location-container">
                                            <button type="button" id="my-location-btn" class="my-location-btn" title="موقعیت من">
                                                <i class="bi bi-geo-alt-fill"></i>
                                                <span class="my-location-text">موقعیت من</span>
                                            </button>
                                        </div>
                                    </div>
                                    
                                    <div id="map-loading" class="map-loading">
                                        <i class="bi bi-arrow-clockwise"></i>
                                        <p>در حال بارگذاری نقشه...</p>
                                    </div>
                                </div>
                                <input type="hidden" id="user_geo_location" name="user_geo_location" value="<?php echo esc_attr($user_geo_location); ?>">
                                
                                <!-- Location Confirmation Button -->
                                <div class="location-button-container">
                                    <button type="button" id="confirm-location-btn" class="btn btn-primary location-confirm-btn" disabled>
                                        <i class="bi bi-check-circle"></i>
                                        <span>ثبت موقعیت</span>
                                    </button>
                                </div>
                                
                                <!-- Location Permission Popup -->
                                <div id="location-permission-popup" class="location-permission-popup" style="display: none;">
                                    <div class="popup-content">
                                        <div class="popup-header">
                                            <i class="bi bi-geo-alt-fill"></i>
                                            <h4>دسترسی به موقعیت</h4>
                                            <button type="button" class="popup-close" id="popup-close">
                                                <i class="bi bi-x"></i>
                                            </button>
                                        </div>
                                        <div class="popup-body">
                                            <p>برای یافتن خودکار موقعیت شما، لطفاً دسترسی به موقعیت را در مرورگر خود فعال کنید.</p>
                                            <p class="popup-help">مراحل فعال‌سازی:</p>
                                            <ol>
                                                <li>روی آیکون قفل یا <span class="popup-icon-circle">i</span> در نوار آدرس کلیک کنید</li>
                                                <li>دسترسی به موقعیت را فعال کنید</li>
                                                <li>روی دکمه <strong>"موقعیت من"</strong> کلیک کنید</li>
                                            </ol>
                                        </div>
                                        <div class="popup-footer">
                                            <button type="button" class="btn btn-secondary btn-close-only" id="popup-close-btn">بستن</button>
                                            <button type="button" class="btn btn-primary" id="popup-dismiss">ادامه</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Address Fields Wrapper -->
                        <div class="address-fields-wrapper">
                            <div class="address-fields-notice">
                                ابتدا موقعیت خود را روی نقشه انتخاب کنید
                            </div>
                            
                            <div class="address-fields-container">
                                <div class="form-field">
                                    <div class="floating-field">
                                        <input type="text" id="user_address" name="user_address" class="form-input" value="<?php echo esc_attr($user_address_data['address'] ?? ''); ?>" data-required="true" disabled autocomplete="street-address">
                                        <label for="user_address" class="floating-label">
                                            <span class="field-icon">
                                                <i class="bi bi-geo-alt"></i>
                                            </span>
                                            <span class="label-text">نشانی</span>
                                        </label>
                                    </div>
                                    <div class="field-description">
                                        برای اطمینان آدرس را چک کرده و در صورت مغایرت اصلاح کنید.
                                    </div>
                                </div>
                                
                                <div class="form-field">
                                    <div class="floating-field">
                                        <input type="text" id="address_details" name="address_details" class="form-input" value="<?php echo esc_attr($user_address_data['details'] ?? ''); ?>" disabled autocomplete="address-line2">
                                        <label for="address_details" class="floating-label">
                                            <span class="field-icon">
                                                <i class="bi bi-building"></i>
                                            </span>
                                            <span class="label-text">جزئیات آدرس</span>
                                        </label>
                                    </div>
                                    <div class="field-description">
                                        مثال: پلاک 3، واحد 4
                                    </div>
                                </div>
                                
                                <div class="form-field">
                                    <div class="floating-field">
                                        <textarea id="address_notes" name="address_notes" class="form-textarea" rows="3" disabled autocomplete="off"><?php echo esc_textarea($user_address_data['notes'] ?? ''); ?></textarea>
                                        <label for="address_notes" class="floating-label">
                                            <span class="field-icon">
                                                <i class="bi bi-chat-text"></i>
                                            </span>
                                            <span class="label-text">توضیحات بیشتر (اختیاری)</span>
                                        </label>
                                    </div>
                                    <div class="field-description">
                                        مثال: به نگهبانی تحویل داده شود
                                    </div>
                                </div>
                                
                                <?php 
                                $user_phone = get_user_meta($current_user->ID, 'user_phone', true);
                                // Convert phone from 98 to 0 format for display
                                if (strpos($user_phone, '98') === 0 && strlen($user_phone) > 10) {
                                    $user_phone = '0' . substr($user_phone, 2);
                                }
                                ?>
                                <div class="form-field">
                                    <div class="floating-field">
                                        <input type="tel" id="address_phone" name="address_phone" class="form-input" value="<?php echo esc_attr($user_phone); ?>" disabled autocomplete="tel">
                                        <label for="address_phone" class="floating-label">
                                            <span class="field-icon">
                                                <i class="bi bi-telephone"></i>
                                            </span>
                                            <span class="label-text">شماره تماس</span>
                                        </label>
                                    </div>
                                    <div class="field-description">
                                        شماره تلفن تحویل گیرنده سفارشات (11 رقم، شروع با 09)
                                    </div>
                                </div>
                                
                                <div class="address-fields-overlay" id="address-fields-overlay"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Step 4: Completion -->
            <div class="form-step <?php echo $current_step == 4 ? 'active' : ''; ?>" data-step="4">
                <div class="step-content">
                    <div class="completion-content">
                        <div class="completion-icon">
                            <i class="bi bi-check-circle"></i>
                        </div>
                        <div class="completion-title">اطلاعات شما با موفقیت تکمیل شد!</div>
                        <div class="completion-redirect">
                            <p class="redirect-countdown">شما در <span id="countdown">3</span> ثانیه به داشبورد منتقل می‌شوید</p>
                        </div>
                        <a href="<?php echo home_url('/p'); ?>" class="btn btn-primary" id="dashboard-btn">
                            ورود به داشبورد
                            <i class="bi bi-arrow-left"></i>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Navigation Buttons -->
            <div class="form-navigation">
                <button type="submit" class="btn btn-primary" id="submit_step">
                    <span class="btn-text">ادامه</span>
                    <span class="btn-loader" style="display: none;">
                        <i class="bi bi-arrow-clockwise"></i>
                    </span>
                    <i class="bi bi-arrow-left"></i>
                </button>
            </div>
        </form>
    </div>
    
    <!-- Previous Step Button (Outside Form Container) -->
    <div class="signup-prev-button-container">
        <button type="button" class="btn-prev-step" id="prev_step" style="display: none;">
            <i class="bi bi-arrow-right"></i>
            <span>مرحله قبل</span>
        </button>
    </div>
</div>

<?php get_footer(); ?>
