<?php
/**
 * Template Name: Login Page
 */

if (is_user_logged_in()) {

    $user = wp_get_current_user();
    $user_roles = $user->roles;
    $home_url = home_url();
    $role_redirects = [
        'Manager' => '/p/m', // Manager
        'Accountant' => '/p/a', // Acountant
        'Lab' => '/p/l', // Lab
        'Supervisor' => '/p/c', // Supervisor
        'Specialist' => '/p/s', // Specialist
        'Client' => '/p', // Client
        'Subscriber' => '/p/sign-up', // Subscriber
    ];

    foreach ($user_roles as $role) {
        if (isset($role_redirects[$role])) {
            wp_redirect($home_url . $role_redirects[$role]);
            exit;
        }
    }
}  

get_header();

?>
<!-- Container for centering the login box -->
<div class="ea_login_container container-fluid d-flex flex-column justify-content-center align-items-center min-vh-100">
    
    <div class="ea_login_header d-flex justify-content-center align-items-center w-100 mb-4">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/brand/logo-dark.png" width="180px" alt="Etiuse Lab Logo" />
    </div>

    <div class="ea_login_wrapper card w-100">

        <div class="ea_login_loader" display="display:none">
            <span class="ea_login_loader_spinner"></span>
        </div>

        <!-- Title -->
        <div class="ea_login_header_content">
            <h1 class="ea_h1 text-right" id="ea_login_title">
                ورود یا عضویت در اتیوس
            </h1>
            <p class="ea_login_subtitle text-right">
                لطفا شماره موبایل و کد امنیتی را وارد کنید
            </p>
        </div>

        <form class="ea_login_form" id="ea_exists_form">
        
            <!-- FORM MESSAGE -->
            <div class="ea_login_message ea_text" id="ea_exists_message" style="display:none;"></div>

            <!-- PHONE -->
            <div class="ea_login_field ea_floating_field">
                <div class="ea_login_field_input_wrapper">
                    <input type="tel" class="ea_login_field_input" id="ea_exists_phone" name="phone" placeholder=" " required>
                    <label class="ea_login_label ea_floating_label" for="phone">
                        <span class="ea_login_field_icon">
                                <?php echo file_get_contents( get_template_directory() . '/assets/icons/phone.svg' ); ?>
                        </span>
                        <span class="ea_login_label_text">
                            تلفن همراه
                        </span>
                    </label>
                </div>
                <!-- <div class="ea_login_field_desc"></div>
                <div class="ea_login_field_error"></div> -->
            </div>

            <!-- VERIFICATION -->
            <div class="ea_login_field ea_login_verification_field">

                <div class="ea_login_verification_field_inner">

                    <div class="ea_login_field_input_wrapper ea_floating_field">
                        <input class="ea_login_field_input" id="ea_exists_verification" type="tel" name="verification" placeholder=" " required autocomplete="off">
                        <label class="ea_login_label ea_floating_label" for="verification">
                            <span class="ea_login_field_icon">
                                    <?php echo file_get_contents( get_template_directory() . '/assets/icons/passcode.svg' ); ?>
                            </span>
                            <span class="ea_login_label_text">
                                کد امنیتی
                            </span>
                        </label>
                        <div class="ea_login_field_desc"></div>
                        <div id="ea_exists_verification_refresh">
                        <?php echo file_get_contents( get_template_directory() . '/assets/icons/refresh.svg' ); ?>
                        </div>
                    </div>
                    <div id="ea_exists_verification_wrapper">
                        <div class="ea_login_loader" display="display:none">
                            <span class="ea_login_loader_spinner"></span>
                        </div>
                        <img src="" alt="Verification Image" style="display:none">
                    </div>
                
                </div>

                <!-- <div class="ea_login_field_desc"></div>
                <div class="ea_login_field_error"></div> -->

            </div>

            <input type="hidden" name="ea_exists_recaptcha_response" id="ea_exists_recaptchaResponse">
            <input type="submit" value="ورود به اتیوس" class="ea_login_submit" id="ea_exists_submit">
        
        </form>

  </div> <!-- END OF ea_login_wrapper -->

  <div class="ea_login_footer text-center ea_text mt-4">
    ورود شما به معنای پذیرش 
    <a class="ea_terms_link" href="/etiuse/terms" target="_blank">شرایط اتیوس</a>
    و
    <a class="ea_terms_link" href="/etiuse/privacy-policy" target="_blank">قوانین حریم‌خصوصی</a>
    است
  </div>

</div>

<?php get_footer(); ?>
